%BASAL FORCINGS class definition
%
%   Usage:
%      basalforcings=basalforcings();

classdef basalforcings
	properties (SetAccess=public) 
		melting_rate             = NaN;
		melting_rate_correction  = NaN;
		geothermalflux           = NaN;
	end
	methods
		function obj = basalforcings(varargin) % {{{
			switch nargin
				case 0
					obj=setdefaultparameters(obj);
				otherwise
					error('constructor not supported');
			end
		end % }}}
		function obj = setdefaultparameters(obj) % {{{

		end % }}}
		function md = checkconsistency(obj,md,solution,analyses) % {{{

			if ismember(PrognosticAnalysisEnum(),analyses) & ~(solution==TransientSolutionEnum() & md.transient.isprognostic==0),
				md = checkfield(md,'basalforcings.melting_rate','NaN',1,'forcing',1);
			end
			if ismember(BalancethicknessAnalysisEnum(),analyses),
				md = checkfield(md,'basalforcings.melting_rate','NaN',1,'size',[md.mesh.numberofvertices 1]);
			end
			if ismember(ThermalAnalysisEnum(),analyses) & ~(solution==TransientSolutionEnum() & md.transient.isthermal==0),
				md = checkfield(md,'basalforcings.melting_rate','NaN',1,'forcing',1);
				md = checkfield(md,'basalforcings.geothermalflux','NaN',1,'forcing',1,'>=',0);
			end
		end % }}}
		function disp(obj) % {{{
			disp(sprintf('   basal forcings parameters:'));

			fielddisplay(obj,'melting_rate','basal melting rate (positive if melting) [m/yr]');
			fielddisplay(obj,'melting_rate_correction','additional melting applied to compensate for dh/dt [m/yr]');
			fielddisplay(obj,'geothermalflux','geothermal heat flux [W/m^2]');

		end % }}}
		function marshall(obj,fid) % {{{
			WriteData(fid,'object',obj,'fieldname','melting_rate','format','DoubleMat','mattype',1);
			WriteData(fid,'object',obj,'fieldname','melting_rate_correction','format','DoubleMat','mattype',1);
			WriteData(fid,'object',obj,'fieldname','geothermalflux','format','DoubleMat','mattype',1);
		end % }}}
	end
end
