/*!\file: numerics.h
 * \brief prototypes for numerics.h
 */ 

#ifndef _NUMERICS_H_
#define  _NUMERICS_H_

#include "./Verbosity.h"
#include "./GaussPoints.h"
#include "./isnan.h"
#include "./recast.h"

class Input;
class Parameters;

struct OptArgs;
struct OptPars;

IssmDouble  min(IssmDouble a,IssmDouble b);
IssmDouble  max(IssmDouble a,IssmDouble b);
int         min(int a,int b);
int         max(int a,int b);
IssmDouble  OptFunc(IssmDouble scalar, OptArgs *optargs);
void        BrentSearch(IssmDouble *psearch_scalar,IssmDouble*pJ,OptPars*optpars,IssmDouble (*f)(IssmDouble,OptArgs*), OptArgs*optargs);
void        OptimalSearch(IssmDouble *psearch_scalar,IssmDouble*pJ,OptPars*optpars,IssmDouble (*f)(IssmDouble,OptArgs*), OptArgs*optargs);
void        cross(IssmDouble *result,IssmDouble*vector1,IssmDouble*vector2);
void        IsInputConverged(IssmDouble *peps, Input**new_inputs,Input**old_inputs,int num_inputs,int criterion_enum);
void        UnitConversion(IssmDouble *values, int numvalues,int direction_enum, int type_enum);
IssmDouble  UnitConversion(IssmDouble value, int direction_enum, int type_enum);
char       *OptionsFromAnalysis(Parameters *parameters,int analysis_type);
void        XZvectorsToCoordinateSystem(IssmDouble *T,IssmDouble*xzvectors);
int         cubic(IssmDouble a, IssmDouble b, IssmDouble c, IssmDouble d, double X[3], int *num);
void        ToolkitsOptionsFromAnalysis(Parameters* parameters,int analysis_type);

#endif //ifndef _NUMERICS_H_
