/*!\file:  ToolkitsOptionsFromAnalysis.cpp
 * \brief: this is mainly for the case where we run our toolkits using petsc. In this case, we need to 
 * plug our toolkits options directly into the petsc options database. This is the case for each analysis type 
 * and parameters
 */ 

#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "../../classes/objects/objects.h"
#include "../../Container/Parameters.h"
#include "../../toolkits/toolkits.h"

void ToolkitsOptionsFromAnalysis(Parameters* parameters,int analysis_type){

	/*intermediary: */
	char* options=NULL;

	/*Recover first the options string for this analysis: */
	options=OptionsFromAnalysis(parameters,analysis_type);

	/*now, reset the petsc options database with this string. Taken from petsc/install/src/sys/objects/pinit.c. This 
	 *capability is not covered by Petsc!: */

	#ifdef _HAVE_PETSC_

	#if _PETSC_MAJOR_ == 2 
	PetscOptionsDestroy();
	PetscOptionsCreate();
	//PetscOptionsCheckInitial_Private();
	//PetscOptionsCheckInitial_Components();
	PetscOptionsSetFromOptions();
	PetscOptionsInsertMultipleString(options); //our patch
	#else
	PetscOptionsSetFromOptions();
	PetscOptionsClear();
	//PetscOptionsSetFromOptions();
	PetscOptionsInsertMultipleString(options); //our patch
	#endif

	#endif

	/*Free ressources:*/
	xDelete<char>(options);
}
