function [var_id,counter] = structtonc(ncid,fieldname,field,depth,var_id,counter,step);
%STRUCTTONC- fill nc file with structure fields
%
%   WARNING: Do not use this function, this function is called
%            by netcdf(model);
%

%update counter
counter   = counter+1;

%Datatype dependent switch
if isa(field,'double') & numel(field)==1,
	if step==1,
		var_id(counter) = netcdf.defVar(ncid,fieldname,'NC_DOUBLE',[]);
	else
		netcdf.putVar(ncid,var_id(counter),field);
	end
elseif isa(field,'double') & size(field,2)==1,
	if step==1,
		dim_id          = netcdf.defDim(ncid,[fieldname '_size1'],size(field,1));
		var_id(counter) = netcdf.defVar(ncid,fieldname,'NC_DOUBLE',dim_id);
	else
		netcdf.putVar(ncid,var_id(counter),field);
	end
elseif isa(field,'double') & size(field,2)>1,
	if step==1,
		dim1_id         = netcdf.defDim(ncid,[fieldname '_size1'],size(field,1));
		dim2_id         = netcdf.defDim(ncid,[fieldname '_size2'],size(field,2));
		var_id(counter) = netcdf.defVar(ncid,fieldname,'NC_DOUBLE',[dim2_id dim1_id]);
	else
		netcdf.putVar(ncid,var_id(counter),transpose(field));
	end
elseif isa(field,'char') & ~isempty(field),
	if step==1,
		dim_id          = netcdf.defDim(ncid,[fieldname '_size1'],numel(field));
		var_id(counter) = netcdf.defVar(ncid,fieldname,'NC_CHAR',dim_id);
	else
		netcdf.putVar(ncid,var_id(counter),transpose(field));
	end
elseif isa(field,'logical') & numel(field)==1,
	if step==1,
		var_id(counter) = netcdf.defVar(ncid,fieldname,'NC_BYTE',[]);
	else
		netcdf.putVar(ncid,var_id(counter),int8(field));
	end
elseif isa(field,'struct'),
	subfields = fields(field);
	for i=1:length(subfields),
		[var_id,counter] = structtonc(ncid,[fieldname '.' subfields{i}],field.(subfields{i}),depth+1,var_id,counter,step);
	end
elseif isobject(field),
	subfields = fields(field);
	for i=1:length(subfields),
		[var_id,counter] = structtonc(ncid,[fieldname '.' subfields{i}],field.(subfields{i}),depth+1,var_id,counter,step);
	end
else
	disp(['skipping ' fieldname '...']);
end
