/*!\file: gia_core.cpp
 * \brief: core of the GIA solution 
 */ 

#include "./solutions.h"
#include "../toolkits/toolkits.h"
#include "../classes/objects/objects.h"
#include "../io/io.h"
#include "../EnumDefinitions/EnumDefinitions.h"
#include "../modules/modules.h"
#include "../solvers/solvers.h"

void gia_core(FemModel* femmodel){
	
	Vector<IssmDouble>*  wg  = NULL;

	/*parameters: */
	bool save_results;
	int  gsize;
	int  configuration_type;

	/*Recover some parameters: */
	femmodel->parameters->FindParam(&save_results,SaveResultsEnum);
	femmodel->parameters->FindParam(&configuration_type,ConfigurationTypeEnum);
	
	if(VerboseSolution()) _pprintLine_("   computing GIA");

	/*Call on core computations: */
	femmodel->SetCurrentConfiguration(GiaAnalysisEnum);

	/*Figure out size of g-set deflection vector and allocate solution vector: */
	gsize      = femmodel->nodes->NumberOfDofs(configuration_type,GsetEnum);
	wg = new Vector<IssmDouble>(gsize);

	/*call the main module: */
	femmodel->Deflection(wg);
	
	InputUpdateFromSolutionx( femmodel->elements,femmodel->nodes, femmodel->vertices, femmodel->loads, femmodel->materials, femmodel->parameters,wg); 

	if(save_results){
		if(VerboseSolution()) _pprintLine_("   saving results");
		InputToResultx(femmodel->elements,femmodel->nodes,femmodel->vertices,femmodel->loads,femmodel->materials,femmodel->parameters,GiaWEnum);
	}

}
