function [mask]=nunataks(mask)
%NUNATAKS - bias mask towards increased 0 covergage
% 
%  mask is an image of arbitrary size, format binary, with values 1 for foreground, and 0 for background
% 
%  Usage:   mask=nunataks(mask)
%           [mask]=aggregation(mask);
%
%  See also CLOSING, OPENING, DILATION, EROSION, AGGREGATION

%check input arguments  %{{{
%even windowsize
if mod(windowsize,2)==0,
	error('windowsize should be an even number');
end

%check on presence of varargin: 
optional=0;
if nargin>3,
	if nargin~=5,
		help aggregation;
		error('wrong number of optional arguments specified');
	else
		optional=1;
		x=varargin{1};
		y=varargin{2};
	end
end

%check on presence of varargout: 
if optional,
	if nargout~=3,
		help aggregation;
		error('wrong number of optional output arguments specified');
	end
end
%}}}

%convolve mask
matrix=ones(windowsize,windowsize); 
mask=filter2(matrix,mask,'same');

%apply threshhold
pos=find(mask>threshhold); 
pos2=find(mask<=threshhold); 
mask(pos)=1;
mask(pos2)=0;

%mask has been transformed into double format from the filter2  operation. Bring back to binary. 
mask=logical(mask);

%subsample: 
s=size(mask);
mask=mask(1:windowsize:s(1),1:windowsize:s(2));

if optional,
	s=size(mask);
	varargout{1}=x(1:windowsize:s(2));
	varargout{2}=y(1:windowsize:s(1));
end


function nunataks();

%Bias towards increased rock coverage:
matrix1=[1 0 1; 0 0 0 ; 1 0 1];
matrix2=[0 1 0; 1 0 1; 0 1 0];



