/*
 * UpdateElementsHydrology:
 */

#include "../../../Container/Container.h"
#include "../../../toolkits/toolkits.h"
#include "../../../io/io.h"
#include "../../../modules/modules.h"
#include "../../../EnumDefinitions/EnumDefinitions.h"
#include "../../../classes/objects/objects.h"
#include "../../../shared/shared.h"
#include "../../MeshPartitionx/MeshPartitionx.h"
#include "../../../include/include.h"
#include "../ModelProcessorx.h"

void	UpdateElementsHydrology(Elements* elements, IoModel* iomodel,int analysis_counter,int analysis_type){

	int    hydrology_model;
	int    numberofelements;

	/*Fetch data needed: */
	iomodel->Constant(&hydrology_model,HydrologyEnum);
	iomodel->Constant(&numberofelements,MeshNumberofelementsEnum);
	iomodel->FetchData(1,MeshElementsEnum);

	/*Update elements: */
	int counter=0;
	for(int i=0;i<numberofelements;i++){
		if(iomodel->my_elements[i]){
			Element* element=(Element*)elements->GetObjectByOffset(counter);
			element->Update(i,iomodel,analysis_counter,analysis_type); //we need i to index into elements.
			counter++;
		}
	}

	iomodel->FetchDataToInput(elements,ThicknessEnum);
	iomodel->FetchDataToInput(elements,SurfaceEnum);
	iomodel->FetchDataToInput(elements,BedEnum);
	iomodel->FetchDataToInput(elements,MaskElementonfloatingiceEnum);
	iomodel->FetchDataToInput(elements,MeshElementonbedEnum);
	iomodel->FetchDataToInput(elements,MeshElementonsurfaceEnum);
	iomodel->FetchDataToInput(elements,MaskElementonwaterEnum);
	iomodel->FetchDataToInput(elements,BasalforcingsMeltingRateEnum);
	if(hydrology_model==HydrologyshreveEnum){
		iomodel->FetchDataToInput(elements,WatercolumnEnum);
		elements->InputDuplicate(WatercolumnEnum,WaterColumnOldEnum);
	}
	else if(hydrology_model==HydrologydcEnum){
		iomodel->FetchDataToInput(elements,SedimentHeadEnum);
	}
	else{
		_error_("Hydrology model "<<EnumToStringx(hydrology_model)<<" not supported yet");
	}

	/*Free data: */
	iomodel->DeleteData(1,MeshElementsEnum);
}
