/*
 * \file EnumDefinitions.h:
 * \brief: enum functions for our objects
 */

#ifndef _ENUM_DEFINITIONS_
#define _ENUM_DEFINITIONS_

#include "../modules/EnumToStringx/EnumToStringx.h"
#include "../modules/StringToEnumx/StringToEnumx.h"

enum definitions{
	/*Model fields {{{1*/
	AutodiffIsautodiffEnum, 
	AutodiffNumDependentsEnum,
	AutodiffNumDependentObjectsEnum,
	AutodiffDependentObjectNamesEnum,
	AutodiffDependentObjectTypesEnum,
	AutodiffDependentObjectIndicesEnum,
	AutodiffDependentObjectsEnum,
	AutodiffNumIndependentsEnum,
	AutodiffNumIndependentObjectsEnum,
	AutodiffIndependentObjectNamesEnum,
	AutodiffIndependentObjectTypesEnum,
	AutodiffIndependentObjectsEnum,
	AutodiffJacobianEnum,
	AutodiffXpEnum,
	AutodiffDriverEnum,
	AutodiffFosForwardIndexEnum,
	AutodiffFovForwardIndicesEnum,
	AutodiffFosReverseIndexEnum,
	AutodiffMassFluxSegmentsPresentEnum,
	AutodiffKeepEnum,
	BalancethicknessSpcthicknessEnum,
	BalancethicknessStabilizationEnum,
	BalancethicknessThickeningRateEnum,
	BasalforcingsGeothermalfluxEnum,
	BasalforcingsMeltingRateCorrectionEnum,
	BasalforcingsMeltingRateEnum,
	BathymetryEnum,
	BedEnum,
	ConstantsGEnum,
	ConstantsReferencetemperatureEnum,
	ConstantsYtsEnum,
	DependentObjectEnum,
	DiagnosticAbstolEnum,
	DiagnosticIcefrontEnum,
	DiagnosticIsnewtonEnum,
	DiagnosticMaxiterEnum,
	DiagnosticNumRequestedOutputsEnum,
	DiagnosticPenaltyFactorEnum,
	DiagnosticReferentialEnum,
	DiagnosticReltolEnum,
	DiagnosticRequestedOutputsEnum,
	DiagnosticRestolEnum,
	DiagnosticRiftPenaltyLockEnum,
	DiagnosticRiftPenaltyThresholdEnum,
	DiagnosticShelfDampeningEnum,
	DiagnosticSpcvxEnum,
	DiagnosticSpcvyEnum,
	DiagnosticSpcvzEnum,
	DiagnosticStokesreconditioningEnum,
	DiagnosticVertexPairingEnum,
	DiagnosticViscosityOvershootEnum,
	LoadingforceXEnum,
	LoadingforceYEnum,
	LoadingforceZEnum,
	FlowequationBordermacayealEnum,
	FlowequationBorderpattynEnum,
	FlowequationBorderstokesEnum,
	FlowequationElementEquationEnum,
	FlowequationIshutterEnum,
	FlowequationIsl1l2Enum,
	FlowequationIsmacayealpattynEnum,
	FlowequationIsstokesEnum,
	FlowequationVertexEquationEnum,
	FrictionCoefficientEnum,
	FrictionPEnum,
	FrictionQEnum,
	GeometryHydrostaticRatioEnum,
	HydrologyEnum,
	HydrologyshreveEnum,
	HydrologyshreveCREnum,
	HydrologyshreveKnEnum,
	HydrologyshreveNEnum,
	HydrologyshrevePEnum,
	HydrologyshreveQEnum,
	HydrologyshreveSpcwatercolumnEnum,
	HydrologyshreveStabilizationEnum,
	HydrologydcEnum,
	SedimentHeadEnum,
       	HydrologydcSpcsedimentHeadEnum,
	HydrologydcSedimentCompressibilityEnum,
	HydrologydcSedimentPorosityEnum,
	HydrologydcSedimentThicknessEnum,
	HydrologydcSedimentTransmitivityEnum,
	HydrologydcWaterDensityEnum,
	HydrologydcWaterCompressibilityEnum,
	IndependentObjectEnum,
	InversionControlParametersEnum,
	InversionCostFunctionEnum,
	InversionCostFunctionThresholdEnum,
	InversionCostFunctionsCoefficientsEnum,
	InversionCostFunctionsEnum,
	InversionGradientOnlyEnum,
	InversionGradientScalingEnum,
	InversionIscontrolEnum,
	InversionTaoEnum,
	InversionIncompleteAdjointEnum,
	InversionMaxParametersEnum,
	InversionMaxiterPerStepEnum,
	InversionMinParametersEnum,
	InversionNstepsEnum,
	InversionNumControlParametersEnum,
	InversionNumCostFunctionsEnum,
	InversionStepThresholdEnum,
	InversionThicknessObsEnum,
	InversionVelObsEnum,
	InversionVxObsEnum,
	InversionVyObsEnum,
	InversionVzObsEnum,
	MaskElementonfloatingiceEnum,
	MaskElementongroundediceEnum,
	MaskElementonwaterEnum,
	MaskVertexonfloatingiceEnum,
	MaskVertexongroundediceEnum,
	MaskVertexonwaterEnum,
	MaterialsBetaEnum,
	MaterialsHeatcapacityEnum,
	MaterialsLatentheatEnum,
	MaterialsMeltingpointEnum,
	MaterialsMixedLayerCapacityEnum,
	MaterialsRheologyBEnum,
	MaterialsRheologyBbarEnum,
	MaterialsRheologyLawEnum,
	MaterialsRheologyNEnum,
	MaterialsRheologyZEnum,
	MaterialsRheologyZbarEnum,
	MaterialsRhoIceEnum,
	MaterialsRhoWaterEnum,
	MaterialsRhoFreshwaterEnum,
	MaterialsMuWaterEnum,
	MaterialsThermalExchangeVelocityEnum,
	MaterialsThermalconductivityEnum,
	MeshAverageVertexConnectivityEnum,
	MeshDimensionEnum,
	MeshEdgesEnum,
	MeshElementconnectivityEnum,
	MeshElementonbedEnum,
	MeshElementonsurfaceEnum,
	MeshElements2dEnum,
	MeshElementsEnum,
	MeshLowerelementsEnum,
	MeshNumberofedgesEnum,
	MeshNumberofelements2dEnum,
	MeshNumberofelementsEnum,
	MeshNumberoflayersEnum,
	MeshNumberofvertices2dEnum,
	MeshNumberofverticesEnum,
	MeshUpperelementsEnum,
	MeshVertexonbedEnum,
	MeshVertexonsurfaceEnum,
	MeshXEnum,
	MeshYEnum,
	MeshZEnum,
	MiscellaneousNameEnum, //FIXME: only used by qmu, should not be marshalled (already in queueing script)
	PrognosticHydrostaticAdjustmentEnum,
	PrognosticMinThicknessEnum,
	PrognosticPenaltyFactorEnum,
	PrognosticSpcthicknessEnum,
	PrognosticStabilizationEnum,
	PrognosticVertexPairingEnum,
	PrognosticNumRequestedOutputsEnum,
	PrognosticRequestedOutputsEnum,
	QmuIsdakotaEnum,
	MassFluxSegmentsEnum,
	MassFluxSegmentsPresentEnum,
	QmuMassFluxSegmentsPresentEnum,
	QmuNumberofpartitionsEnum,
	QmuNumberofresponsesEnum,
	QmuPartitionEnum,
	QmuResponsedescriptorsEnum,
	QmuVariabledescriptorsEnum,
	RiftsNumriftsEnum,
	RiftsRiftstructEnum,
	SettingsIoGatherEnum,
	SettingsLowmemEnum,
	SettingsOutputFrequencyEnum,
	SettingsResultsAsPatchesEnum,
	SettingsWaitonlockEnum,
	SurfaceforcingsDelta18oEnum,
	SurfaceforcingsDelta18oSurfaceEnum,
	SurfaceforcingsIsdelta18oEnum,
	SurfaceforcingsPrecipitationsPresentdayEnum,
	SurfaceforcingsTemperaturesPresentdayEnum,
	SurfaceforcingsTemperaturesLgmEnum,
	DebugProfilingEnum,
	ProfilingCurrentMemEnum,
	ProfilingCurrentFlopsEnum,
	ProfilingSolutionTimeEnum,
	MaxIterationConvergenceFlagEnum,
	SteadystateMaxiterEnum,
	SteadystateNumRequestedOutputsEnum,
	SteadystateReltolEnum,
	SteadystateRequestedOutputsEnum,
	SurfaceEnum,
	SurfaceforcingsPrecipitationEnum,
	SurfaceforcingsMassBalanceEnum,
	SurfaceforcingsIspddEnum,
	SurfaceforcingsIssmbgradientsEnum,
	SurfaceforcingsMonthlytemperaturesEnum,
	SurfaceforcingsHrefEnum,
	SurfaceforcingsSmbrefEnum,
	SurfaceforcingsBPosEnum,
	SurfaceforcingsBNegEnum,
	ThermalMaxiterEnum,
	ThermalPenaltyFactorEnum,
	ThermalPenaltyLockEnum,
	ThermalPenaltyThresholdEnum,
	ThermalSpctemperatureEnum,
	ThermalStabilizationEnum,
	ThermalIsenthalpyEnum,
	ThicknessEnum,
	TimesteppingStartTimeEnum,
	TimesteppingFinalTimeEnum,
	TimesteppingCflCoefficientEnum,
	TimesteppingTimeAdaptEnum,
	TimesteppingTimeStepEnum,
	TransientIsdiagnosticEnum,
	TransientIsgroundinglineEnum,
	TransientIsprognosticEnum,
	TransientIsthermalEnum,
	TransientIsgiaEnum,
	TransientNumRequestedOutputsEnum,
	TransientRequestedOutputsEnum,
	/*}}}*/
	/*Solutions and Analyses{{{1 */
	SolutionTypeEnum,
	AnalysisTypeEnum,
	ConfigurationTypeEnum,
	AdjointBalancethicknessAnalysisEnum,
	AdjointHorizAnalysisEnum,
	AdjointSolutionEnum,
	AnalysisCounterEnum,
	BalancethicknessAnalysisEnum,
	BalancethicknessSolutionEnum,
	WeakBalancethicknessAnalysisEnum,
	WeakBalancethicknessSolutionEnum,
	BedSlopeAnalysisEnum,
	BedSlopeSolutionEnum,
	BedSlopeXAnalysisEnum,
	BedSlopeYAnalysisEnum,
	DiagnosticHorizAnalysisEnum,
	DiagnosticHutterAnalysisEnum,
	DiagnosticSolutionEnum,
	DiagnosticVertAnalysisEnum,
	EnthalpyAnalysisEnum,
	EnthalpySolutionEnum,
	FlaimAnalysisEnum,
	FlaimSolutionEnum,
	HydrologyAnalysisEnum,
	HydrologySolutionEnum,
	MeltingAnalysisEnum,
	NoneAnalysisEnum,
	PrognosticAnalysisEnum,
	PrognosticSolutionEnum,
	SteadystateSolutionEnum,
	SurfaceSlopeAnalysisEnum,
	SurfaceSlopeSolutionEnum,
	SurfaceSlopeXAnalysisEnum,
	SurfaceSlopeYAnalysisEnum,
	ThermalAnalysisEnum,
	ThermalSolutionEnum,
	TransientSolutionEnum,
	GiaSolutionEnum,
	GiaAnalysisEnum,
	/*}}}*/
	/*Approximations {{{1*/
	ApproximationEnum,
	NoneApproximationEnum,
	HutterApproximationEnum,
	MacAyealApproximationEnum,
	MacAyealPattynApproximationEnum,
	MacAyealStokesApproximationEnum,
	L1L2ApproximationEnum,
	PattynApproximationEnum,
	PattynStokesApproximationEnum,
	StokesApproximationEnum,
	/*}}}*/
	/*Datasets {{{1*/
	ConstraintsEnum,
	LoadsEnum,
	MaterialsEnum,
	NodesEnum,
	ParametersEnum,
	VerticesEnum,
	ResultsEnum,
	/*}}}*/
	/*Objects {{{1*/
	GenericParamEnum,
	AdolcParamEnum,
	BoolInputEnum,
	BoolParamEnum,
	ContourEnum,
	ControlInputEnum,
	DatasetInputEnum,
	DofIndexingEnum,
	DoubleInputEnum,
	DataSetParamEnum,
	DoubleMatArrayParamEnum,
	DoubleMatParamEnum,
	DoubleParamEnum,
	DoubleVecParamEnum,
	ElementEnum,
	ElementResultEnum,
	ExternalResultEnum,
	FileParamEnum,
	HookEnum,
	IcefrontEnum,
	InputEnum,
	IntInputEnum,
	IntParamEnum,
	IntVecParamEnum,
	TransientParamEnum,
	MacAyeal2dIceFrontEnum,
	MacAyeal3dIceFrontEnum,
	MaticeEnum,
	MatdamageiceEnum,
	MatparEnum,
	NodeEnum,
	NumericalfluxEnum,
	ParamEnum,
	L1L2IceFrontEnum,
	PattynIceFrontEnum,
	PengridEnum,
	PenpairEnum,
	PentaEnum,
	PentaP1InputEnum,
	ProfilerEnum,
	MatrixParamEnum,
	VectorParamEnum,
	RiftfrontEnum,
	SegmentEnum,
	SegmentRiftfrontEnum,
	SpcDynamicEnum,
	SpcStaticEnum,
	SpcTransientEnum,
	StokesIceFrontEnum,
	StringArrayParamEnum,
	StringParamEnum,
	TriaEnum,
	TriaP1InputEnum,
	VertexEnum,
	/*}}}*/
	/*Fill {{{1*/
	AirEnum,
	IceEnum,
	MelangeEnum,
	WaterEnum,
	/*}}}*/
	/*Rift state {{{1*/
	ClosedEnum,
	FreeEnum,
	OpenEnum,
	/*}}}*/
	/*Inputs {{{1*/
	AdjointpEnum,
	AdjointxEnum,
	AdjointyEnum,
	AdjointzEnum,
	BalancethicknessMisfitEnum,
	BedSlopeXEnum,
	BedSlopeYEnum,
	BoundaryEnum,
	ConstantEnum,
	ConvergedEnum,
	ExtToIuEnum,
	FillEnum,
	FractionIncrementEnum,
	FrictionEnum,
	GroundinglineMeltingRateEnum,
	InternalEnum,
	IuToExtEnum,
	MassFluxEnum,
	MaxPenetrationEnum,
	MeltingOffsetEnum,
	MisfitEnum,
	NumberNodeToElementConnectivityEnum,
	PressureEnum,
	PressurePicardEnum,
	QmuPressureEnum,
	QmuVxEnum,
	QmuVyEnum,
	QmuVzEnum,
	QmuThicknessEnum,
	QmuBedEnum,
	QmuSurfaceEnum,
	QmuMeltingEnum,
	AndroidFrictionCoefficientEnum,
	ResetPenaltiesEnum,
	SegmentOnIceShelfEnum,
	SurfaceAbsVelMisfitEnum,
	SurfaceAreaEnum,
	SurfaceAverageVelMisfitEnum,
	SurfaceLogVelMisfitEnum,
	SurfaceLogVxVyMisfitEnum,
	SurfaceRelVelMisfitEnum,
	SurfaceSlopeXEnum,
	SurfaceSlopeYEnum,
	TemperatureEnum,
	TemperatureOldEnum,
	TemperaturePicardEnum,
	TemperatureSurfaceEnum,
	TemperatureBasalEnum,
	ThicknessAbsMisfitEnum,
	TypeEnum,
	VelEnum,
	VelocityEnum,
	VxAverageEnum,
	VxEnum,
	VxPicardEnum,
	VyAverageEnum,
	VyEnum,
	VyPicardEnum,
	VzEnum,
	VzMacAyealEnum,
	VzPattynEnum,
	VzPicardEnum,
	VzStokesEnum,
	VxMeshEnum,
	VyMeshEnum,
	VzMeshEnum,
	EnthalpyEnum,
	EnthalpyPicardEnum,
	ThicknessAbsGradientEnum,
	ThicknessAlongGradientEnum,
	ThicknessAcrossGradientEnum,
	StepResponsesEnum,
	IntMatParamEnum,
	RheologyBbarAbsGradientEnum,
	DragCoefficientAbsGradientEnum,
	TransientInputEnum,
	WaterfractionEnum,
	WatercolumnEnum,
	BasalFrictionEnum,
	ViscousHeatingEnum,
	QmuTemperatureEnum,
	HydrologyWaterVxEnum,
	HydrologyWaterVyEnum,
	StressTensorEnum,
	StressTensorxxEnum,
	StressTensorxyEnum,
	StressTensorxzEnum,
	StressTensoryyEnum,
	StressTensoryzEnum,
	StressTensorzzEnum,
	GiaWEnum,
	/*}}}*/
	/*Element Interpolations{{{1*/
	P0Enum,
	P1Enum,
	P1DGEnum,
	/*}}}*/
	/*Results{{{1*/
	SaveResultsEnum,
	BoolElementResultEnum,
	BoolExternalResultEnum,
	DoubleElementResultEnum,
	DoubleExternalResultEnum,
	DoubleMatExternalResultEnum,
	DoubleVecExternalResultEnum,
	IntExternalResultEnum,
	JEnum,
	PatchEnum,
	PatchNodesEnum,
	PatchVerticesEnum,
	PentaP1ElementResultEnum,
	PetscVecExternalResultEnum,
	StringExternalResultEnum,
	StepEnum,
	TimeEnum,
	TriaP1ElementResultEnum,
	WaterColumnOldEnum,
	/*}}}*/
	/*Responses{{{1*/
	MinVelEnum,
	MaxVelEnum,
	MinVxEnum,
	MaxVxEnum,
	MaxAbsVxEnum,
	MinVyEnum,
	MaxVyEnum,
	MaxAbsVyEnum,
	MinVzEnum,
	MaxVzEnum,
	MaxAbsVzEnum,
	IceVolumeEnum,
	TotalSmbEnum,
	/*}}}*/
	/*Convergence{{{1*/
	RelativeEnum,
	AbsoluteEnum,
	IncrementalEnum,
	/*}}}*/
	/*Grounding Line{{{1*/
	AgressiveMigrationEnum,
	NoneEnum,
	SoftMigrationEnum,
	SubelementMigrationEnum,
	GroundedPortionEnum,
	GLlevelsetEnum,
	/*}}}*/
	/*Solver{{{1*/
	StokesSolverEnum,
	/*}}}*/
	/*Parameters{{{1*/
	AdjointEnum,
	ColinearEnum,
	ControlSteadyEnum,
	FsetEnum,
	Gradient1Enum,
	Gradient2Enum,
	Gradient3Enum,
	GradientEnum,
	GroundinglineMigrationEnum,
	GsetEnum,
	IndexEnum,
	IndexedEnum,
	IntersectEnum,
	NodalEnum,
	OldGradientEnum,
	OutputFilePointerEnum,
	OutputFileNameEnum,
	LockFileNameEnum,
	PetscOptionsAnalysesEnum,
	PetscOptionsStringsEnum,
	QmuErrNameEnum,
	QmuInNameEnum,
	QmuOutNameEnum,
	RegularEnum,
	ScaledEnum,
	SeparateEnum,
	SsetEnum,
	VerboseEnum,
	/*}}}*/
	/*Interpolation {{{1*/
	TriangleInterpEnum,
	BilinearInterpEnum,
	NearestInterpEnum,
	/*}}}*/
	/*Coordinate Systems{{{1*/
	XYEnum,
	XYZPEnum,
	/*}}}*/
	/*Options{{{1*/
	OptionEnum,
	GenericOptionEnum,
	OptionCellEnum,
	OptionCharEnum,
	OptionStructEnum,
	OptionDoubleEnum,
	OptionLogicalEnum,
	/*}}}*/
	/*Rheology law (move too Material) {{{1*/
	PatersonEnum,
	ArrheniusEnum,
	/*}}}*/
	MaximumNumberOfEnums
};

#endif
