package gov.nasa.jpl.issm;

import android.view.View;
import android.view.animation.DecelerateInterpolator;
import android.widget.ImageView;
import android.widget.TextView;

class SwapViews implements Runnable {
	private boolean mIsFirstView;
	private boolean containTextView;
	ImageView mainImage;
	ImageView infoImage;
	TextView text;
	
	public SwapViews(boolean isFirstView, ImageView image, TextView text) {
	 mIsFirstView = isFirstView;
	 containTextView = true;
	 this.mainImage = image;
	 this.text = text;
	}
	
	public SwapViews(boolean isFirstView, ImageView front, ImageView back) {
		mIsFirstView = isFirstView;
		 containTextView = false;
		 this.mainImage = front;
		 this.infoImage  = back;
	}
	
	public void run() {
	 final float centerX = mainImage.getWidth() / 2.0f;
	 final float centerY = mainImage.getHeight() / 2.0f;
	 FlipAnimation rotation;
	
	 if (mIsFirstView) 
	 {
		 mainImage.setVisibility(View.GONE);
		 if(containTextView)
		 {
			 text.setVisibility(View.VISIBLE);
			 text.requestFocus();
		 }
		 else
		 {
		    infoImage.setVisibility(View.VISIBLE);
		 	infoImage.requestFocus();
		 }
	     rotation = new FlipAnimation(-90, 0, centerX, centerY);
	 } else 
	 {
		 if(containTextView)
		 {
			 text.setVisibility(View.GONE);
		 }
		 else infoImage.setVisibility(View.GONE);
		 mainImage.setVisibility(View.VISIBLE);
		 mainImage.requestFocus();
	
	     rotation = new FlipAnimation(90, 0, centerX, centerY);
	 }
	
	 rotation.setDuration(500);
	 rotation.setFillAfter(true);
	 rotation.setInterpolator(new DecelerateInterpolator());
	
	 if (mIsFirstView) 
	 {
		 if(containTextView)
			 text.startAnimation(rotation);
		 else 
			 infoImage.setAnimation(rotation);
	 } 
	 else 
	 {
		 mainImage.startAnimation(rotation);
	 }
   }
}
