package gov.nasa.jpl.issm;

import android.view.animation.Animation;
import android.view.animation.Animation.AnimationListener;
import android.widget.ImageView;
import android.widget.TextView;

class DisplayNextView implements AnimationListener {

	private boolean mCurrentView;
	private boolean containTextView;
	ImageView mainImage;
	ImageView infoImage;
	TextView text;

	public DisplayNextView(boolean currentView, ImageView image, TextView text) {
		mCurrentView = currentView;
		containTextView = true;
		mainImage = image;
		this.text = text;
	}
	
	public DisplayNextView(boolean currentView, ImageView front, ImageView back) {
		mCurrentView = currentView;
		containTextView = false;
		mainImage = front;
		infoImage = back;
	}

	public void onAnimationStart(Animation animation) {
	}

	public void onAnimationEnd(Animation animation) {
		if(containTextView)
			mainImage.post(new SwapViews(mCurrentView, mainImage, text));
		else
			mainImage.post(new SwapViews(mCurrentView, mainImage, infoImage));
	}

	public void onAnimationRepeat(Animation animation) {
	}
}
