%HYDROLOGYDC class definition
%
%   Usage:
%      hydrologydc=hydrologydc();

classdef hydrologydc
	properties (SetAccess=public) 
		spcsedimenthead  = NaN;
		sedimentporosity = 0;
	end
	methods
		function obj = hydrologydc(varargin) % {{{
			switch nargin
				case 0
					obj=setdefaultparameters(obj);
				otherwise
					error('constructor not supported');
			end
		end % }}}
		function obj = setdefaultparameters(obj) % {{{

			%Parameters from de Fleurian 2013
			obj.sedimentporosity = .01;

		end % }}}
		function md = checkconsistency(obj,md,solution,analyses) % {{{

			%Early return
			if ~ismember(HydrologyAnalysisEnum(),analyses), return; end

			md = checkfield(md,'hydrology.spcsedimenthead','forcing',1);
			md = checkfield(md,'hydrology.sedimentporosity','>',0,'numel',1);
		end % }}}
		function disp(obj) % {{{
			disp(sprintf('   hydrology Dual Porous Continuum Equivalent parameters:'));

			fielddisplay(obj,'spcsedimenthead','sediment water head constraints (NaN means no constraint, meters above MSL)');
			fielddisplay(obj,'sedimentporosity','sediment porosity (dimensionless)');

		end % }}}
		function marshall(obj,fid) % {{{
			WriteData(fid,'enum',HydrologyEnum(),'data',HydrologydcEnum(),'format','Integer');
			WriteData(fid,'object',obj,'fieldname','spcsedimenthead','format','DoubleMat','mattype',1);
			WriteData(fid,'object',obj,'fieldname','sedimentporosity','format','Double');
		end % }}}
	end
end
