/*
 * CreateConstraintsHydrology.c:
 */

#include "../../../Container/Container.h"
#include "../../../modules/modules.h"
#include "../../../toolkits/toolkits.h"
#include "../../../EnumDefinitions/EnumDefinitions.h"
#include "../../../io/io.h"
#include "../../../classes/objects/objects.h"
#include "../../../shared/shared.h"
#include "../ModelProcessorx.h"

void	CreateConstraintsHydrology(Constraints** pconstraints, IoModel* iomodel){

	/*Recover pointer: */
	int          hydrology_model;
	Constraints* constraints=*pconstraints;

	/*retrieve some parameters: */
	iomodel->Constant(&hydrology_model,HydrologyEnum);

	/*Create constraints if they do not exist yet*/
	if(!constraints) constraints = new Constraints();

	if(hydrology_model==HydrologyshreveEnum){
		IoModelToConstraintsx(constraints,iomodel,HydrologyshreveSpcwatercolumnEnum,HydrologyAnalysisEnum);
	}
	else if(hydrology_model==HydrologydcEnum){
		IoModelToConstraintsx(constraints,iomodel,HydrologydcSpcsedimentheadEnum,HydrologyAnalysisEnum);
	}
	else{
		_error_("Hydrology model "<<EnumToStringx(hydrology_model)<<" not supported yet");
	}

	/*Assign output pointer: */
	*pconstraints=constraints;
}
