import numpy
import copy
from model import *
from triangle import *
from setmask import *
from parameterize import *
from setflowequation import *
from EnumDefinitions import *
from solve import *
from MatlabFuncs import *

md=triangle(model(),'../Exp/Square.exp',150000.)
md=setmask(md,'','')
md=parameterize(md,'../Par/SquareSheetConstrained.py')
md=setflowequation(md,'macayeal','all')
md.cluster=generic('name',oshostname(),'np',3)
md.initialization.watercolumn=1e-3*numpy.ones((md.mesh.numberofvertices,1))
md.hydrology.spcwatercolumn=float('nan')*numpy.ones((md.mesh.numberofvertices,1))
pos=numpy.nonzero(md.mesh.y==0)[0]
md.hydrology.spcwatercolumn[pos]=2e-3
md=solve(md,HydrologySolutionEnum())

#Fields and tolerances to track changes
field_names     =['HydrologyWaterVx','HydrologyWaterVy','WaterColumn']
field_tolerances=[1e-09,1e-09,1e-09]
field_values=[\
	md.results.HydrologySolution[0].HydrologyWaterVx,\
	md.results.HydrologySolution[0].HydrologyWaterVy,\
	md.results.HydrologySolution[0].Watercolumn,\
	]
