%TRANSIENT class definition
%
%   Usage:
%      transient=transient();

classdef transient
	properties (SetAccess=public) 
		isprognostic      = 0;
		isdiagnostic      = 0;
		isthermal         = 0;
		isgroundingline   = 0;
		isgia             = 0;
		requested_outputs = NaN;
	end
	methods
		function obj = transient(varargin) % {{{
			switch nargin
				case 0
					obj=setdefaultparameters(obj);
				otherwise
					error('constructor not supported');
			end
		end % }}}
		function obj = setdefaultparameters(obj) % {{{

			%full analysis: Diagnostic, Prognostic and Thermal but no groundingline migration for now
			obj.isprognostic=1;
			obj.isdiagnostic=1;
			obj.isthermal=1;
			obj.isgroundingline=0;
			obj.isgia=0;

		end % }}}
		function md = checkconsistency(obj,md,solution,analyses) % {{{

			%Early return
			if solution~=TransientSolutionEnum(), return; end

			md = checkfield(md,'transient.isprognostic','numel',[1],'values',[0 1]);
			md = checkfield(md,'transient.isdiagnostic','numel',[1],'values',[0 1]);
			md = checkfield(md,'transient.isthermal','numel',[1],'values',[0 1]);
			md = checkfield(md,'transient.isgroundingline','numel',[1],'values',[0 1]);
			md = checkfield(md,'transient.isgia','numel',[1],'values',[0 1]);
			md = checkfield(md,'transient.requested_outputs','size',[NaN 1]);

		end % }}}
		function disp(obj) % {{{
			disp(sprintf('   transient solution parameters:'));

			fielddisplay(obj,'isprognostic','indicates if a prognostic solution is used in the transient');
			fielddisplay(obj,'isdiagnostic','indicates if a diagnostic solution is used in the transient');
			fielddisplay(obj,'isthermal','indicates if a thermal solution is used in the transient');
			fielddisplay(obj,'isgroundingline','indicates if a groundingline migration is used in the transient');
			fielddisplay(obj,'isgia','indicates if a postglacial rebound model is used in the transient');
			fielddisplay(obj,'requested_outputs','list of additional outputs requested');

		end % }}}
		function marshall(obj,fid) % {{{
			WriteData(fid,'object',obj,'fieldname','isprognostic','format','Boolean');
			WriteData(fid,'object',obj,'fieldname','isdiagnostic','format','Boolean');
			WriteData(fid,'object',obj,'fieldname','isthermal','format','Boolean');
			WriteData(fid,'object',obj,'fieldname','isgroundingline','format','Boolean');
			WriteData(fid,'object',obj,'fieldname','isgia','format','Boolean');
			WriteData(fid,'object',obj,'fieldname','requested_outputs','format','DoubleMat','mattype',3);
		end % }}}
	end
end
