function nightlyrun(varargin)
%NIGHTLYRUN - run the nighlty tests on 'tests/Verification'
%
%   This function goes to each directory of 'tests/Verifications' and
%   launch the nightly tests. A specific package can be given in input
%   only this package will be tested
%
%  Usage:
%      nightlyrun(varargin)
%
%   Example:
%      nightlyrun;
%      nightlyrun({'ice'});
%      nightlyrun({'cielo_serial','cielo_parallel'});
%      nightlyrun({'ice'},{'prognostic','diagnostic'});

%check arguments
if (nargin>2)
	help nightlyrun
	error('nightlyrun error message: bad usage');
end

%use ISSM_DIR generated by startup.m
global ISSM_DIR

%Go to Test directory
eval(['cd ' ISSM_DIR '/test/']);

%Run all verification tests
cd Verification

[status,list]=system('ls -1 '); %will work on all machines, hopefully
list=strsplit(list,char(10));
list=list(1:end-1);

%Get packages
if nargin,
	packages=varargin{1};
else
	packages={'macayeal','ice','cielo_serial','cielo_parallel'};
end

%Go through list of decks, and run the deck runme.m files package by package.
for i=1:length(packages),
	for j=1:length(list),
		eval(['cd ' list{j}]);
		if nargin==2,
			runme(packages(i),varargin{2});
		else
			runme(packages(i));
		end
		cd ..
	end
end

%display needed by nightlyrun.sh to check that no error popped up.
disp('NIGHTLYRUNTERMINATEDCORRECTLY');
