/*!\file: gia_core.cpp
 * \brief: core of the GIA solution 
 */ 

#include "./solutions.h"
#include "../toolkits/toolkits.h"
#include "../classes/objects/objects.h"
#include "../io/io.h"
#include "../EnumDefinitions/EnumDefinitions.h"
#include "../modules/modules.h"
#include "../solvers/solvers.h"

void gia_core(FemModel* femmodel){

	/*parameters: */
	bool save_results;

	/*Recover some parameters: */
	femmodel->parameters->FindParam(&save_results,SaveResultsEnum);

	if(VerboseSolution()) _pprintLine_("   computing slope");

	/*Call on core computations: */
	femmodel->SetCurrentConfiguration(GiaAnalysisEnum);
	solver_linear(femmodel);

	if(save_results){
		if(VerboseSolution()) _pprintLine_("   saving results");
		InputToResultx(femmodel->elements,femmodel->nodes,femmodel->vertices,femmodel->loads,femmodel->materials,femmodel->parameters,GiaWEnum);
	}

}
