package gov.nasa.jpl.issm;

import android.view.View;
import android.view.animation.DecelerateInterpolator;
import android.widget.ImageView;
import android.widget.TextView;

public final class SwapViews implements Runnable {
	private boolean mIsFirstView;
	ImageView image;
	TextView text;
	
	public SwapViews(boolean isFirstView, ImageView image, TextView text) {
	 mIsFirstView = isFirstView;
	 this.image = image;
	 this.text = text;
	}
	
	public void run() {
	 final float centerX = image.getWidth() / 2.0f;
	 final float centerY = image.getHeight() / 2.0f;
	 FlipAnimation rotation;
	
	 if (mIsFirstView) {
	  image.setVisibility(View.GONE);
	  text.setVisibility(View.VISIBLE);
	  text.requestFocus();
	
	     rotation = new FlipAnimation(-90, 0, centerX, centerY);
	 } else {
	  text.setVisibility(View.GONE);
	  image.setVisibility(View.VISIBLE);
	  image.requestFocus();
	
	     rotation = new FlipAnimation(90, 0, centerX, centerY);
	 }
	
	 rotation.setDuration(500);
	 rotation.setFillAfter(true);
	 rotation.setInterpolator(new DecelerateInterpolator());
	
	 if (mIsFirstView) {
	  text.startAnimation(rotation);
	 } else {
	  image.startAnimation(rotation);
	 }
	}
}
