function mask=aggregation(mask,windowsize,threshhold)
%congrid algorithm using windowsize pixel neighboors.

%check on windowsize
if mod(windowsize,2)==0,
	error('windowsize should be an even number');
end

%convolve: 
matrix=ones(windowsize,windowsize); 

%convolve mask: 
mask=filter2(matrix,double(mask),'same');

pos=find(mask>threshhold); 
pos2=find(mask<=threshhold); 
mask(pos)=1;
mask(pos2)=0;

%now subsample: 
s=size(mask);
mask=mask(1:windowsize:s(1),1:windowsize:s(2));
