package gov.nasa.jpl.issm;

/////////////////////////////////////////////////////////
class ColorMap
{
	private double[][] d;
	final int rowNumber = 64;
//-------------------------------------------------------
	public ColorMap()
	{
		setDefault();
	}
//-------------------------------------------------------
	public double[][] getColorBuffer()
	{
		return d;
	}
//--------------------------------------------------------
	public void setColor(String color)
	{
		String cl = color.toLowerCase().trim();
		if (cl.equals("hsv")) setDefault();
		if (cl.equals("autumn")) setAutumn();
		if (cl.equals("bone")) setBone();
		if (cl.equals("cool")) setCool();
		if (cl.equals("copper")) setCopper();
		if (cl.equals("gray")) setGray();
		if (cl.equals("hot")) setHot();
		if (cl.equals("jet")) setJet();
		if (cl.equals("pink")) setPink();
		if (cl.equals("spring")) setSpring();
		if (cl.equals("winter")) setWinter();
		if (cl.equals("summer")) setSummer();
	}
//--------------------------------------------------------	
	//set default color map => hsv {{{
	public void setDefault()
	{
		d = new double[][]{	
				{1.0, 	0.0, 	0.0 },
				{ 1.0, 	0.0938, 	0.0 },
				{ 1.0, 	0.1875, 	0.0 },
				{ 1.0, 	0.2813, 	0.0 },
				{ 1.0, 	0.375, 	0.0 },
				{ 1.0, 	0.4688, 	0.0 },
				{ 1.0, 	0.5625, 	0.0 },
				{ 1.0, 	0.6563, 	0.0 },
				{ 1.0, 	0.75, 	0.0 },
				{ 1.0, 	0.8438, 	0.0 },
				{ 1.0, 	0.9375, 	0.0 },
				{ 0.9688, 	1.0, 	0.0 },
				{ 0.875, 	1.0, 	0.0 },
				{ 0.7813, 	1.0, 	0.0 },
				{ 0.6875, 	1.0, 	0.0 },
				{ 0.5938, 	1.0, 	0.0 },
				{ 0.5, 	1.0, 	0.0 },
				{ 0.4063, 	1.0, 	0.0 },
				{ 0.3125, 	1.0, 	0.0 },
				{ 0.2188, 	1.0, 	0.0 },
				{ 0.125, 	1.0, 	0.0 },
				{ 0.0313, 	1.0, 	0.0 },
				{ 0.0, 	1.0, 	0.0625 },
				{ 0.0, 	1.0, 	0.1563 },
				{ 0.0, 	1.0, 	0.25 },
				{ 0.0, 	1.0, 	0.3438 },
				{ 0.0, 	1.0, 	0.4375 },
				{ 0.0, 	1.0, 	0.5313 },
				{ 0.0, 	1.0, 	0.625 },
				{ 0.0, 	1.0, 	0.7188 },
				{ 0.0, 	1.0, 	0.8125 },
				{ 0.0, 	1.0, 	0.9063 },
				{ 0.0, 	1.0, 	1.0 },
				{ 0.0, 	0.9063, 	1.0 },
				{ 0.0, 	0.8125, 	1.0 },
				{ 0.0, 	0.7188, 	1.0 },
				{ 0.0, 	0.625, 	1.0 },
				{ 0.0, 	0.5313, 	1.0 },
				{ 0.0, 	0.4375, 	1.0 },
				{ 0.0, 	0.3438, 	1.0 },
				{ 0.0, 	0.25, 	1.0 },
				{ 0.0, 	0.1563, 	1.0 },
				{ 0.0, 	0.0625, 	1.0 },
				{ 0.0313, 	0.0, 	1.0 },
				{ 0.125, 	0.0, 	1.0 },
				{ 0.2188, 	0.0, 	1.0 },
				{ 0.3125, 	0.0, 	1.0 },
				{ 0.4063, 	0.0, 	1.0 },
				{ 0.5, 	0.0, 	1.0 },
				{ 0.5938, 	0.0, 	1.0 },
				{ 0.6875, 	0.0, 	1.0 },
				{ 0.7813, 	0.0, 	1.0 },
				{ 0.875, 	0.0, 	1.0 },
				{ 0.9688, 	0.0, 	1.0 },
				{ 1.0, 	0.0, 	0.9375 },
				{ 1.0, 	0.0, 	0.8438 },
				{ 1.0, 	0.0, 	0.75 },
				{ 1.0, 	0.0, 	0.6563 },
				{ 1.0, 	0.0, 	0.5625 },
				{ 1.0, 	0.0, 	0.4688 },
				{ 1.0, 	0.0, 	0.375 },
				{ 1.0, 	0.0, 	0.2813 },
				{ 1.0, 	0.0, 	0.1875 },
				{ 1.0, 	0.0, 	0.0938 }
			};
	} 
	//}}}
//-------------------------------------------------------
	public void setAutumn()
	{
		d = new double[][]{
				{ 1.0, 	0.0, 	0.0 },
				{ 1.0, 	0.0159, 	0.0 },
				{ 1.0, 	0.0317, 	0.0 },
				{ 1.0, 	0.0476, 	0.0 },
				{ 1.0, 	0.0635, 	0.0 },
				{ 1.0, 	0.0794, 	0.0 },
				{ 1.0, 	0.0952, 	0.0 },
				{ 1.0, 	0.1111, 	0.0 },
				{ 1.0, 	0.127, 	0.0 },
				{ 1.0, 	0.1429, 	0.0 },
				{ 1.0, 	0.1587, 	0.0 },
				{ 1.0, 	0.1746, 	0.0 },
				{ 1.0, 	0.1905, 	0.0 },
				{ 1.0, 	0.2063, 	0.0 },
				{ 1.0, 	0.2222, 	0.0 },
				{ 1.0, 	0.2381, 	0.0 },
				{ 1.0, 	0.254, 	0.0 },
				{ 1.0, 	0.2698, 	0.0 },
				{ 1.0, 	0.2857, 	0.0 },
				{ 1.0, 	0.3016, 	0.0 },
				{ 1.0, 	0.3175, 	0.0 },
				{ 1.0, 	0.3333, 	0.0 },
				{ 1.0, 	0.3492, 	0.0 },
				{ 1.0, 	0.3651, 	0.0 },
				{ 1.0, 	0.381, 	0.0 },
				{ 1.0, 	0.3968, 	0.0 },
				{ 1.0, 	0.4127, 	0.0 },
				{ 1.0, 	0.4286, 	0.0 },
				{ 1.0, 	0.4444, 	0.0 },
				{ 1.0, 	0.4603, 	0.0 },
				{ 1.0, 	0.4762, 	0.0 },
				{ 1.0, 	0.4921, 	0.0 },
				{ 1.0, 	0.5079, 	0.0 },
				{ 1.0, 	0.5238, 	0.0 },
				{ 1.0, 	0.5397, 	0.0 },
				{ 1.0, 	0.5556, 	0.0 },
				{ 1.0, 	0.5714, 	0.0 },
				{ 1.0, 	0.5873, 	0.0 },
				{ 1.0, 	0.6032, 	0.0 },
				{ 1.0, 	0.619, 	0.0 },
				{ 1.0, 	0.6349, 	0.0 },
				{ 1.0, 	0.6508, 	0.0 },
				{ 1.0, 	0.6667, 	0.0 },
				{ 1.0, 	0.6825, 	0.0 },
				{ 1.0, 	0.6984, 	0.0 },
				{ 1.0, 	0.7143, 	0.0 },
				{ 1.0, 	0.7302, 	0.0 },
				{ 1.0, 	0.746, 	0.0 },
				{ 1.0, 	0.7619, 	0.0 },
				{ 1.0, 	0.7778, 	0.0 },
				{ 1.0, 	0.7937, 	0.0 },
				{ 1.0, 	0.8095, 	0.0 },
				{ 1.0, 	0.8254, 	0.0 },
				{ 1.0, 	0.8413, 	0.0 },
				{ 1.0, 	0.8571, 	0.0 },
				{ 1.0, 	0.873, 	0.0 },
				{ 1.0, 	0.8889, 	0.0 },
				{ 1.0, 	0.9048, 	0.0 },
				{ 1.0, 	0.9206, 	0.0 },
				{ 1.0, 	0.9365, 	0.0 },
				{ 1.0, 	0.9524, 	0.0 },
				{ 1.0, 	0.9683, 	0.0 },
				{ 1.0, 	0.9841, 	0.0 },
				{ 1.0, 	1.0, 	0.0 }
			};
	}
//-------------------------------------------------------
	public void setBone()
	{
		d = new double[][]{
				{ 0.0, 	0.0, 	0.0052 },
				{ 0.0139, 	0.0139, 	0.0243 },
				{ 0.0278, 	0.0278, 	0.0434 },
				{ 0.0417, 	0.0417, 	0.0625 },
				{ 0.0556, 	0.0556, 	0.0816 },
				{ 0.0694, 	0.0694, 	0.1007 },
				{ 0.0833, 	0.0833, 	0.1198 },
				{ 0.0972, 	0.0972, 	0.1389 },
				{ 0.1111, 	0.1111, 	0.158 },
				{ 0.125, 	0.125, 	0.1771 },
				{ 0.1389, 	0.1389, 	0.1962 },
				{ 0.1528, 	0.1528, 	0.2153 },
				{ 0.1667, 	0.1667, 	0.2344 },
				{ 0.1806, 	0.1806, 	0.2535 },
				{ 0.1944, 	0.1944, 	0.2726 },
				{ 0.2083, 	0.2083, 	0.2917 },
				{ 0.2222, 	0.2222, 	0.3108 },
				{ 0.2361, 	0.2361, 	0.3299 },
				{ 0.25, 	0.25, 	0.349 },
				{ 0.2639, 	0.2639, 	0.3681 },
				{ 0.2778, 	0.2778, 	0.3872 },
				{ 0.2917, 	0.2917, 	0.4062 },
				{ 0.3056, 	0.3056, 	0.4253 },
				{ 0.3194, 	0.3194, 	0.4444 },
				{ 0.3333, 	0.3385, 	0.4583 },
				{ 0.3472, 	0.3576, 	0.4722 },
				{ 0.3611, 	0.3767, 	0.4861 },
				{ 0.375, 	0.3958, 	0.5 },
				{ 0.3889, 	0.4149, 	0.5139 },
				{ 0.4028, 	0.434, 	0.5278 },
				{ 0.4167, 	0.4531, 	0.5417 },
				{ 0.4306, 	0.4722, 	0.5556 },
				{ 0.4444, 	0.4913, 	0.5694 },
				{ 0.4583, 	0.5104, 	0.5833 },
				{ 0.4722, 	0.5295, 	0.5972 },
				{ 0.4861, 	0.5486, 	0.6111 },
				{ 0.5, 	0.5677, 	0.625 },
				{ 0.5139, 	0.5868, 	0.6389 },
				{ 0.5278, 	0.6059, 	0.6528 },
				{ 0.5417, 	0.625, 	0.6667 },
				{ 0.5556, 	0.6441, 	0.6806 },
				{ 0.5694, 	0.6632, 	0.6944 },
				{ 0.5833, 	0.6823, 	0.7083 },
				{ 0.5972, 	0.7014, 	0.7222 },
				{ 0.6111, 	0.7205, 	0.7361 },
				{ 0.625, 	0.7396, 	0.75 },
				{ 0.6389, 	0.7587, 	0.7639 },
				{ 0.6528, 	0.7778, 	0.7778 },
				{ 0.6745, 	0.7917, 	0.7917 },
				{ 0.6962, 	0.8056, 	0.8056 },
				{ 0.7179, 	0.8194, 	0.8194 },
				{ 0.7396, 	0.8333, 	0.8333 },
				{ 0.7613, 	0.8472, 	0.8472 },
				{ 0.783, 	0.8611, 	0.8611 },
				{ 0.8047, 	0.875, 	0.875 },
				{ 0.8264, 	0.8889, 	0.8889 },
				{ 0.8481, 	0.9028, 	0.9028 },
				{ 0.8698, 	0.9167, 	0.9167 },
				{ 0.8915, 	0.9306, 	0.9306 },
				{ 0.9132, 	0.9444, 	0.9444 },
				{ 0.9349, 	0.9583, 	0.9583 },
				{ 0.9566, 	0.9722, 	0.9722 },
				{ 0.9783, 	0.9861, 	0.9861 },
				{ 1.0, 	1.0, 	1.0 }
			};
	}		
//-------------------------------------------------------
	public void setCool()
	{
		d = new double[][]{
				{ 0.0, 	1.0, 	1.0 },
				{ 0.0159, 	0.9841, 	1.0 },
				{ 0.0317, 	0.9683, 	1.0 },
				{ 0.0476, 	0.9524, 	1.0 },
				{ 0.0635, 	0.9365, 	1.0 },
				{ 0.0794, 	0.9206, 	1.0 },
				{ 0.0952, 	0.9048, 	1.0 },
				{ 0.1111, 	0.8889, 	1.0 },
				{ 0.127, 	0.873, 	1.0 },
				{ 0.1429, 	0.8571, 	1.0 },
				{ 0.1587, 	0.8413, 	1.0 },
				{ 0.1746, 	0.8254, 	1.0 },
				{ 0.1905, 	0.8095, 	1.0 },
				{ 0.2063, 	0.7937, 	1.0 },
				{ 0.2222, 	0.7778, 	1.0 },
				{ 0.2381, 	0.7619, 	1.0 },
				{ 0.254, 	0.746, 	1.0 },
				{ 0.2698, 	0.7302, 	1.0 },
				{ 0.2857, 	0.7143, 	1.0 },
				{ 0.3016, 	0.6984, 	1.0 },
				{ 0.3175, 	0.6825, 	1.0 },
				{ 0.3333, 	0.6667, 	1.0 },
				{ 0.3492, 	0.6508, 	1.0 },
				{ 0.3651, 	0.6349, 	1.0 },
				{ 0.381, 	0.619, 	1.0 },
				{ 0.3968, 	0.6032, 	1.0 },
				{ 0.4127, 	0.5873, 	1.0 },
				{ 0.4286, 	0.5714, 	1.0 },
				{ 0.4444, 	0.5556, 	1.0 },
				{ 0.4603, 	0.5397, 	1.0 },
				{ 0.4762, 	0.5238, 	1.0 },
				{ 0.4921, 	0.5079, 	1.0 },
				{ 0.5079, 	0.4921, 	1.0 },
				{ 0.5238, 	0.4762, 	1.0 },
				{ 0.5397, 	0.4603, 	1.0 },
				{ 0.5556, 	0.4444, 	1.0 },
				{ 0.5714, 	0.4286, 	1.0 },
				{ 0.5873, 	0.4127, 	1.0 },
				{ 0.6032, 	0.3968, 	1.0 },
				{ 0.619, 	0.381, 	1.0 },
				{ 0.6349, 	0.3651, 	1.0 },
				{ 0.6508, 	0.3492, 	1.0 },
				{ 0.6667, 	0.3333, 	1.0 },
				{ 0.6825, 	0.3175, 	1.0 },
				{ 0.6984, 	0.3016, 	1.0 },
				{ 0.7143, 	0.2857, 	1.0 },
				{ 0.7302, 	0.2698, 	1.0 },
				{ 0.746, 	0.254, 	1.0 },
				{ 0.7619, 	0.2381, 	1.0 },
				{ 0.7778, 	0.2222, 	1.0 },
				{ 0.7937, 	0.2063, 	1.0 },
				{ 0.8095, 	0.1905, 	1.0 },
				{ 0.8254, 	0.1746, 	1.0 },
				{ 0.8413, 	0.1587, 	1.0 },
				{ 0.8571, 	0.1429, 	1.0 },
				{ 0.873, 	0.127, 	1.0 },
				{ 0.8889, 	0.1111, 	1.0 },
				{ 0.9048, 	0.0952, 	1.0 },
				{ 0.9206, 	0.0794, 	1.0 },
				{ 0.9365, 	0.0635, 	1.0 },
				{ 0.9524, 	0.0476, 	1.0 },
				{ 0.9683, 	0.0317, 	1.0 },
				{ 0.9841, 	0.0159, 	1.0 },
				{ 1.0, 	0.0, 	1.0 }
			};
	}
//-------------------------------------------------------
	public void setCopper()
	{
		d = new double[][]{
				{ 0.0, 	0.0, 	0.0 },
				{ 0.0198, 	0.0124, 	0.0079 },
				{ 0.0397, 	0.0248, 	0.0158 },
				{ 0.0595, 	0.0372, 	0.0237 },
				{ 0.0794, 	0.0496, 	0.0316 },
				{ 0.0992, 	0.062, 	0.0395 },
				{ 0.119, 	0.0744, 	0.0474 },
				{ 0.1389, 	0.0868, 	0.0553 },
				{ 0.1587, 	0.0992, 	0.0632 },
				{ 0.1786, 	0.1116, 	0.0711 },
				{ 0.1984, 	0.124, 	0.079 },
				{ 0.2183, 	0.1364, 	0.0869 },
				{ 0.2381, 	0.1488, 	0.0948 },
				{ 0.2579, 	0.1612, 	0.1027 },
				{ 0.2778, 	0.1736, 	0.1106 },
				{ 0.2976, 	0.186, 	0.1185 },
				{ 0.3175, 	0.1984, 	0.1263 },
				{ 0.3373, 	0.2108, 	0.1342 },
				{ 0.3571, 	0.2232, 	0.1421 },
				{ 0.377, 	0.2356, 	0.15 },
				{ 0.3968, 	0.248, 	0.1579 },
				{ 0.4167, 	0.2604, 	0.1658 },
				{ 0.4365, 	0.2728, 	0.1737 },
				{ 0.4563, 	0.2852, 	0.1816 },
				{ 0.4762, 	0.2976, 	0.1895 },
				{ 0.496, 	0.31, 	0.1974 },
				{ 0.5159, 	0.3224, 	0.2053 },
				{ 0.5357, 	0.3348, 	0.2132 },
				{ 0.5556, 	0.3472, 	0.2211 },
				{ 0.5754, 	0.3596, 	0.229 },
				{ 0.5952, 	0.372, 	0.2369 },
				{ 0.6151, 	0.3844, 	0.2448 },
				{ 0.6349, 	0.3968, 	0.2527 },
				{ 0.6548, 	0.4092, 	0.2606 },
				{ 0.6746, 	0.4216, 	0.2685 },
				{ 0.6944, 	0.434, 	0.2764 },
				{ 0.7143, 	0.4464, 	0.2843 },
				{ 0.7341, 	0.4588, 	0.2922 },
				{ 0.754, 	0.4712, 	0.3001 },
				{ 0.7738, 	0.4836, 	0.308 },
				{ 0.7937, 	0.496, 	0.3159 },
				{ 0.8135, 	0.5084, 	0.3238 },
				{ 0.8333, 	0.5208, 	0.3317 },
				{ 0.8532, 	0.5332, 	0.3396 },
				{ 0.873, 	0.5456, 	0.3475 },
				{ 0.8929, 	0.558, 	0.3554 },
				{ 0.9127, 	0.5704, 	0.3633 },
				{ 0.9325, 	0.5828, 	0.3712 },
				{ 0.9524, 	0.5952, 	0.379 },
				{ 0.9722, 	0.6076, 	0.3869 },
				{ 0.9921, 	0.62, 	0.3948 },
				{ 1.0, 	0.6324, 	0.4027 },
				{ 1.0, 	0.6448, 	0.4106 },
				{ 1.0, 	0.6572, 	0.4185 },
				{ 1.0, 	0.6696, 	0.4264 },
				{ 1.0, 	0.682, 	0.4343 },
				{ 1.0, 	0.6944, 	0.4422 },
				{ 1.0, 	0.7068, 	0.4501 },
				{ 1.0, 	0.7192, 	0.458 },
				{ 1.0, 	0.7316, 	0.4659 },
				{ 1.0, 	0.744, 	0.4738 },
				{ 1.0, 	0.7564, 	0.4817 },
				{ 1.0, 	0.7688, 	0.4896 },
				{ 1.0, 	0.7812, 	0.4975 },
			};
	}
//-------------------------------------------------------
	public void setGray()
	{
		d = new double[][]{
				{ 0.0, 	0.0, 	0.0 },
				{ 0.0159, 	0.0159, 	0.0159 },
				{ 0.0317, 	0.0317, 	0.0317 },
				{ 0.0476, 	0.0476, 	0.0476 },
				{ 0.0635, 	0.0635, 	0.0635 },
				{ 0.0794, 	0.0794, 	0.0794 },
				{ 0.0952, 	0.0952, 	0.0952 },
				{ 0.1111, 	0.1111, 	0.1111 },
				{ 0.127, 	0.127, 	0.127 },
				{ 0.1429, 	0.1429, 	0.1429 },
				{ 0.1587, 	0.1587, 	0.1587 },
				{ 0.1746, 	0.1746, 	0.1746 },
				{ 0.1905, 	0.1905, 	0.1905 },
				{ 0.2063, 	0.2063, 	0.2063 },
				{ 0.2222, 	0.2222, 	0.2222 },
				{ 0.2381, 	0.2381, 	0.2381 },
				{ 0.254, 	0.254, 	0.254 },
				{ 0.2698, 	0.2698, 	0.2698 },
				{ 0.2857, 	0.2857, 	0.2857 },
				{ 0.3016, 	0.3016, 	0.3016 },
				{ 0.3175, 	0.3175, 	0.3175 },
				{ 0.3333, 	0.3333, 	0.3333 },
				{ 0.3492, 	0.3492, 	0.3492 },
				{ 0.3651, 	0.3651, 	0.3651 },
				{ 0.381, 	0.381, 	0.381 },
				{ 0.3968, 	0.3968, 	0.3968 },
				{ 0.4127, 	0.4127, 	0.4127 },
				{ 0.4286, 	0.4286, 	0.4286 },
				{ 0.4444, 	0.4444, 	0.4444 },
				{ 0.4603, 	0.4603, 	0.4603 },
				{ 0.4762, 	0.4762, 	0.4762 },
				{ 0.4921, 	0.4921, 	0.4921 },
				{ 0.5079, 	0.5079, 	0.5079 },
				{ 0.5238, 	0.5238, 	0.5238 },
				{ 0.5397, 	0.5397, 	0.5397 },
				{ 0.5556, 	0.5556, 	0.5556 },
				{ 0.5714, 	0.5714, 	0.5714 },
				{ 0.5873, 	0.5873, 	0.5873 },
				{ 0.6032, 	0.6032, 	0.6032 },
				{ 0.619, 	0.619, 	0.619 },
				{ 0.6349, 	0.6349, 	0.6349 },
				{ 0.6508, 	0.6508, 	0.6508 },
				{ 0.6667, 	0.6667, 	0.6667 },
				{ 0.6825, 	0.6825, 	0.6825 },
				{ 0.6984, 	0.6984, 	0.6984 },
				{ 0.7143, 	0.7143, 	0.7143 },
				{ 0.7302, 	0.7302, 	0.7302 },
				{ 0.746, 	0.746, 	0.746 },
				{ 0.7619, 	0.7619, 	0.7619 },
				{ 0.7778, 	0.7778, 	0.7778 },
				{ 0.7937, 	0.7937, 	0.7937 },
				{ 0.8095, 	0.8095, 	0.8095 },
				{ 0.8254, 	0.8254, 	0.8254 },
				{ 0.8413, 	0.8413, 	0.8413 },
				{ 0.8571, 	0.8571, 	0.8571 },
				{ 0.873, 	0.873, 	0.873 },
				{ 0.8889, 	0.8889, 	0.8889 },
				{ 0.9048, 	0.9048, 	0.9048 },
				{ 0.9206, 	0.9206, 	0.9206 },
				{ 0.9365, 	0.9365, 	0.9365 },
				{ 0.9524, 	0.9524, 	0.9524 },
				{ 0.9683, 	0.9683, 	0.9683 },
				{ 0.9841, 	0.9841, 	0.9841 },
				{ 1.0, 	1.0, 	1.0 }
			};
	}
//-------------------------------------------------------
	public void setHot()
	{
		d = new double[][]{
				{ 0.0417, 	0.0, 	0.0 },
				{ 0.0833, 	0.0, 	0.0 },
				{ 0.125, 	0.0, 	0.0 },
				{ 0.1667, 	0.0, 	0.0 },
				{ 0.2083, 	0.0, 	0.0 },
				{ 0.25, 	0.0, 	0.0 },
				{ 0.2917, 	0.0, 	0.0 },
				{ 0.3333, 	0.0, 	0.0 },
				{ 0.375, 	0.0, 	0.0 },
				{ 0.4167, 	0.0, 	0.0 },
				{ 0.4583, 	0.0, 	0.0 },
				{ 0.5, 	0.0, 	0.0 },
				{ 0.5417, 	0.0, 	0.0 },
				{ 0.5833, 	0.0, 	0.0 },
				{ 0.625, 	0.0, 	0.0 },
				{ 0.6667, 	0.0, 	0.0 },
				{ 0.7083, 	0.0, 	0.0 },
				{ 0.75, 	0.0, 	0.0 },
				{ 0.7917, 	0.0, 	0.0 },
				{ 0.8333, 	0.0, 	0.0 },
				{ 0.875, 	0.0, 	0.0 },
				{ 0.9167, 	0.0, 	0.0 },
				{ 0.9583, 	0.0, 	0.0 },
				{ 1.0, 	0.0, 	0.0 },
				{ 1.0, 	0.0417, 	0.0 },
				{ 1.0, 	0.0833, 	0.0 },
				{ 1.0, 	0.125, 	0.0 },
				{ 1.0, 	0.1667, 	0.0 },
				{ 1.0, 	0.2083, 	0.0 },
				{ 1.0, 	0.25, 	0.0 },
				{ 1.0, 	0.2917, 	0.0 },
				{ 1.0, 	0.3333, 	0.0 },
				{ 1.0, 	0.375, 	0.0 },
				{ 1.0, 	0.4167, 	0.0 },
				{ 1.0, 	0.4583, 	0.0 },
				{ 1.0, 	0.5, 	0.0 },
				{ 1.0, 	0.5417, 	0.0 },
				{ 1.0, 	0.5833, 	0.0 },
				{ 1.0, 	0.625, 	0.0 },
				{ 1.0, 	0.6667, 	0.0 },
				{ 1.0, 	0.7083, 	0.0 },
				{ 1.0, 	0.75, 	0.0 },
				{ 1.0, 	0.7917, 	0.0 },
				{ 1.0, 	0.8333, 	0.0 },
				{ 1.0, 	0.875, 	0.0 },
				{ 1.0, 	0.9167, 	0.0 },
				{ 1.0, 	0.9583, 	0.0 },
				{ 1.0, 	1.0, 	0.0 },
				{ 1.0, 	1.0, 	0.0625 },
				{ 1.0, 	1.0, 	0.125 },
				{ 1.0, 	1.0, 	0.1875 },
				{ 1.0, 	1.0, 	0.25 },
				{ 1.0, 	1.0, 	0.3125 },
				{ 1.0, 	1.0, 	0.375 },
				{ 1.0, 	1.0, 	0.4375 },
				{ 1.0, 	1.0, 	0.5 },
				{ 1.0, 	1.0, 	0.5625 },
				{ 1.0, 	1.0, 	0.625 },
				{ 1.0, 	1.0, 	0.6875 },
				{ 1.0, 	1.0, 	0.75 },
				{ 1.0, 	1.0, 	0.8125 },
				{ 1.0, 	1.0, 	0.875 },
				{ 1.0, 	1.0, 	0.9375 },
				{ 1.0, 	1.0, 	1.0 },
			};
	}
//-------------------------------------------------------
	public void setJet()
	{
		d = new double[][]{
				{ 0.0, 	0.0, 	0.5625 },
				{ 0.0, 	0.0, 	0.625 },
				{ 0.0, 	0.0, 	0.6875 },
				{ 0.0, 	0.0, 	0.75 },
				{ 0.0, 	0.0, 	0.8125 },
				{ 0.0, 	0.0, 	0.875 },
				{ 0.0, 	0.0, 	0.9375 },
				{ 0.0, 	0.0, 	1.0 },
				{ 0.0, 	0.0625, 	1.0 },
				{ 0.0, 	0.125, 	1.0 },
				{ 0.0, 	0.1875, 	1.0 },
				{ 0.0, 	0.25, 	1.0 },
				{ 0.0, 	0.3125, 	1.0 },
				{ 0.0, 	0.375, 	1.0 },
				{ 0.0, 	0.4375, 	1.0 },
				{ 0.0, 	0.5, 	1.0 },
				{ 0.0, 	0.5625, 	1.0 },
				{ 0.0, 	0.625, 	1.0 },
				{ 0.0, 	0.6875, 	1.0 },
				{ 0.0, 	0.75, 	1.0 },
				{ 0.0, 	0.8125, 	1.0 },
				{ 0.0, 	0.875, 	1.0 },
				{ 0.0, 	0.9375, 	1.0 },
				{ 0.0, 	1.0, 	1.0 },
				{ 0.0625, 	1.0, 	0.9375 },
				{ 0.125, 	1.0, 	0.875 },
				{ 0.1875, 	1.0, 	0.8125 },
				{ 0.25, 	1.0, 	0.75 },
				{ 0.3125, 	1.0, 	0.6875 },
				{ 0.375, 	1.0, 	0.625 },
				{ 0.4375, 	1.0, 	0.5625 },
				{ 0.5, 	1.0, 	0.5 },
				{ 0.5625, 	1.0, 	0.4375 },
				{ 0.625, 	1.0, 	0.375 },
				{ 0.6875, 	1.0, 	0.3125 },
				{ 0.75, 	1.0, 	0.25 },
				{ 0.8125, 	1.0, 	0.1875 },
				{ 0.875, 	1.0, 	0.125 },
				{ 0.9375, 	1.0, 	0.0625 },
				{ 1.0, 	1.0, 	0.0 },
				{ 1.0, 	0.9375, 	0.0 },
				{ 1.0, 	0.875, 	0.0 },
				{ 1.0, 	0.8125, 	0.0 },
				{ 1.0, 	0.75, 	0.0 },
				{ 1.0, 	0.6875, 	0.0 },
				{ 1.0, 	0.625, 	0.0 },
				{ 1.0, 	0.5625, 	0.0 },
				{ 1.0, 	0.5, 	0.0 },
				{ 1.0, 	0.4375, 	0.0 },
				{ 1.0, 	0.375, 	0.0 },
				{ 1.0, 	0.3125, 	0.0 },
				{ 1.0, 	0.25, 	0.0 },
				{ 1.0, 	0.1875, 	0.0 },
				{ 1.0, 	0.125, 	0.0 },
				{ 1.0, 	0.0625, 	0.0 },
				{ 1.0, 	0.0, 	0.0 },
				{ 0.9375, 	0.0, 	0.0 },
				{ 0.875, 	0.0, 	0.0 },
				{ 0.8125, 	0.0, 	0.0 },
				{ 0.75, 	0.0, 	0.0 },
				{ 0.6875, 	0.0, 	0.0 },
				{ 0.625, 	0.0, 	0.0 },
				{ 0.5625, 	0.0, 	0.0 },
				{ 0.5, 	0.0, 	0.0 }
			};
	}
//-------------------------------------------------------
	public void setPink()
	{
		d = new double[][]{
				{ 0.1179, 	0.0, 	0.0 },
				{ 0.1959, 	0.1029, 	0.1029 },
				{ 0.2507, 	0.1455, 	0.1455 },
				{ 0.2955, 	0.1782, 	0.1782 },
				{ 0.3343, 	0.2057, 	0.2057 },
				{ 0.3691, 	0.23, 	0.23 },
				{ 0.4009, 	0.252, 	0.252 },
				{ 0.4303, 	0.2722, 	0.2722 },
				{ 0.4579, 	0.291, 	0.291 },
				{ 0.4839, 	0.3086, 	0.3086 },
				{ 0.5085, 	0.3253, 	0.3253 },
				{ 0.532, 	0.3412, 	0.3412 },
				{ 0.5546, 	0.3563, 	0.3563 },
				{ 0.5762, 	0.3709, 	0.3709 },
				{ 0.5971, 	0.3849, 	0.3849 },
				{ 0.6172, 	0.3984, 	0.3984 },
				{ 0.6367, 	0.4115, 	0.4115 },
				{ 0.6557, 	0.4241, 	0.4241 },
				{ 0.6741, 	0.4364, 	0.4364 },
				{ 0.692, 	0.4484, 	0.4484 },
				{ 0.7094, 	0.46, 	0.46 },
				{ 0.7265, 	0.4714, 	0.4714 },
				{ 0.7431, 	0.4825, 	0.4825 },
				{ 0.7594, 	0.4933, 	0.4933 },
				{ 0.7664, 	0.5175, 	0.504 },
				{ 0.7732, 	0.5407, 	0.5143 },
				{ 0.78, 	0.5628, 	0.5245 },
				{ 0.7868, 	0.5842, 	0.5345 },
				{ 0.7935, 	0.6048, 	0.5443 },
				{ 0.8001, 	0.6247, 	0.554 },
				{ 0.8067, 	0.644, 	0.5634 },
				{ 0.8133, 	0.6627, 	0.5727 },
				{ 0.8197, 	0.6809, 	0.5819 },
				{ 0.8262, 	0.6986, 	0.5909 },
				{ 0.8325, 	0.7159, 	0.5998 },
				{ 0.8389, 	0.7328, 	0.6086 },
				{ 0.8452, 	0.7493, 	0.6172 },
				{ 0.8514, 	0.7655, 	0.6257 },
				{ 0.8576, 	0.7813, 	0.6341 },
				{ 0.8637, 	0.7968, 	0.6424 },
				{ 0.8698, 	0.812, 	0.6506 },
				{ 0.8759, 	0.827, 	0.6587 },
				{ 0.8819, 	0.8416, 	0.6667 },
				{ 0.8879, 	0.856, 	0.6746 },
				{ 0.8938, 	0.8702, 	0.6824 },
				{ 0.8997, 	0.8842, 	0.6901 },
				{ 0.9056, 	0.8979, 	0.6977 },
				{ 0.9114, 	0.9114, 	0.7052 },
				{ 0.9172, 	0.9172, 	0.7272 },
				{ 0.923, 	0.923, 	0.7485 },
				{ 0.9287, 	0.9287, 	0.7692 },
				{ 0.9344, 	0.9344, 	0.7893 },
				{ 0.94, 	0.94, 	0.809 },
				{ 0.9456, 	0.9456, 	0.8282 },
				{ 0.9512, 	0.9512, 	0.8469 },
				{ 0.9567, 	0.9567, 	0.8653 },
				{ 0.9623, 	0.9623, 	0.8832 },
				{ 0.9677, 	0.9677, 	0.9008 },
				{ 0.9732, 	0.9732, 	0.9181 },
				{ 0.9786, 	0.9786, 	0.9351 },
				{ 0.984, 	0.984, 	0.9517 },
				{ 0.9894, 	0.9894, 	0.9681 },
				{ 0.9947, 	0.9947, 	0.9842 },
				{ 1.0, 	1.0, 	1.0 }
			};
	}
//-------------------------------------------------------
	public void setSpring()
	{
		d = new double[][]{
				{ 1.0, 	0.0, 	1.0 },
				{ 1.0, 	0.0159, 	0.9841 },
				{ 1.0, 	0.0317, 	0.9683 },
				{ 1.0, 	0.0476, 	0.9524 },
				{ 1.0, 	0.0635, 	0.9365 },
				{ 1.0, 	0.0794, 	0.9206 },
				{ 1.0, 	0.0952, 	0.9048 },
				{ 1.0, 	0.1111, 	0.8889 },
				{ 1.0, 	0.127, 	0.873 },
				{ 1.0, 	0.1429, 	0.8571 },
				{ 1.0, 	0.1587, 	0.8413 },
				{ 1.0, 	0.1746, 	0.8254 },
				{ 1.0, 	0.1905, 	0.8095 },
				{ 1.0, 	0.2063, 	0.7937 },
				{ 1.0, 	0.2222, 	0.7778 },
				{ 1.0, 	0.2381, 	0.7619 },
				{ 1.0, 	0.254, 	0.746 },
				{ 1.0, 	0.2698, 	0.7302 },
				{ 1.0, 	0.2857, 	0.7143 },
				{ 1.0, 	0.3016, 	0.6984 },
				{ 1.0, 	0.3175, 	0.6825 },
				{ 1.0, 	0.3333, 	0.6667 },
				{ 1.0, 	0.3492, 	0.6508 },
				{ 1.0, 	0.3651, 	0.6349 },
				{ 1.0, 	0.381, 	0.619 },
				{ 1.0, 	0.3968, 	0.6032 },
				{ 1.0, 	0.4127, 	0.5873 },
				{ 1.0, 	0.4286, 	0.5714 },
				{ 1.0, 	0.4444, 	0.5556 },
				{ 1.0, 	0.4603, 	0.5397 },
				{ 1.0, 	0.4762, 	0.5238 },
				{ 1.0, 	0.4921, 	0.5079 },
				{ 1.0, 	0.5079, 	0.4921 },
				{ 1.0, 	0.5238, 	0.4762 },
				{ 1.0, 	0.5397, 	0.4603 },
				{ 1.0, 	0.5556, 	0.4444 },
				{ 1.0, 	0.5714, 	0.4286 },
				{ 1.0, 	0.5873, 	0.4127 },
				{ 1.0, 	0.6032, 	0.3968 },
				{ 1.0, 	0.619, 	0.381 },
				{ 1.0, 	0.6349, 	0.3651 },
				{ 1.0, 	0.6508, 	0.3492 },
				{ 1.0, 	0.6667, 	0.3333 },
				{ 1.0, 	0.6825, 	0.3175 },
				{ 1.0, 	0.6984, 	0.3016 },
				{ 1.0, 	0.7143, 	0.2857 },
				{ 1.0, 	0.7302, 	0.2698 },
				{ 1.0, 	0.746, 	0.254 },
				{ 1.0, 	0.7619, 	0.2381 },
				{ 1.0, 	0.7778, 	0.2222 },
				{ 1.0, 	0.7937, 	0.2063 },
				{ 1.0, 	0.8095, 	0.1905 },
				{ 1.0, 	0.8254, 	0.1746 },
				{ 1.0, 	0.8413, 	0.1587 },
				{ 1.0, 	0.8571, 	0.1429 },
				{ 1.0, 	0.873, 	0.127 },
				{ 1.0, 	0.8889, 	0.1111 },
				{ 1.0, 	0.9048, 	0.0952 },
				{ 1.0, 	0.9206, 	0.0794 },
				{ 1.0, 	0.9365, 	0.0635 },
				{ 1.0, 	0.9524, 	0.0476 },
				{ 1.0, 	0.9683, 	0.0317 },
				{ 1.0, 	0.9841, 	0.0159 },
				{ 1.0, 	1.0, 	0.0 }
			};
	}
//-------------------------------------------------------
	public void setSummer()
	{
		d = new double[][]{
				{ 0.0, 	0.5, 	0.4 },
				{ 0.0159, 	0.5079, 	0.4 },
				{ 0.0317, 	0.5159, 	0.4 },
				{ 0.0476, 	0.5238, 	0.4 },
				{ 0.0635, 	0.5317, 	0.4 },
				{ 0.0794, 	0.5397, 	0.4 },
				{ 0.0952, 	0.5476, 	0.4 },
				{ 0.1111, 	0.5556, 	0.4 },
				{ 0.127, 	0.5635, 	0.4 },
				{ 0.1429, 	0.5714, 	0.4 },
				{ 0.1587, 	0.5794, 	0.4 },
				{ 0.1746, 	0.5873, 	0.4 },
				{ 0.1905, 	0.5952, 	0.4 },
				{ 0.2063, 	0.6032, 	0.4 },
				{ 0.2222, 	0.6111, 	0.4 },
				{ 0.2381, 	0.619, 	0.4 },
				{ 0.254, 	0.627, 	0.4 },
				{ 0.2698, 	0.6349, 	0.4 },
				{ 0.2857, 	0.6429, 	0.4 },
				{ 0.3016, 	0.6508, 	0.4 },
				{ 0.3175, 	0.6587, 	0.4 },
				{ 0.3333, 	0.6667, 	0.4 },
				{ 0.3492, 	0.6746, 	0.4 },
				{ 0.3651, 	0.6825, 	0.4 },
				{ 0.381, 	0.6905, 	0.4 },
				{ 0.3968, 	0.6984, 	0.4 },
				{ 0.4127, 	0.7063, 	0.4 },
				{ 0.4286, 	0.7143, 	0.4 },
				{ 0.4444, 	0.7222, 	0.4 },
				{ 0.4603, 	0.7302, 	0.4 },
				{ 0.4762, 	0.7381, 	0.4 },
				{ 0.4921, 	0.746, 	0.4 },
				{ 0.5079, 	0.754, 	0.4 },
				{ 0.5238, 	0.7619, 	0.4 },
				{ 0.5397, 	0.7698, 	0.4 },
				{ 0.5556, 	0.7778, 	0.4 },
				{ 0.5714, 	0.7857, 	0.4 },
				{ 0.5873, 	0.7937, 	0.4 },
				{ 0.6032, 	0.8016, 	0.4 },
				{ 0.619, 	0.8095, 	0.4 },
				{ 0.6349, 	0.8175, 	0.4 },
				{ 0.6508, 	0.8254, 	0.4 },
				{ 0.6667, 	0.8333, 	0.4 },
				{ 0.6825, 	0.8413, 	0.4 },
				{ 0.6984, 	0.8492, 	0.4 },
				{ 0.7143, 	0.8571, 	0.4 },
				{ 0.7302, 	0.8651, 	0.4 },
				{ 0.746, 	0.873, 	0.4 },
				{ 0.7619, 	0.881, 	0.4 },
				{ 0.7778, 	0.8889, 	0.4 },
				{ 0.7937, 	0.8968, 	0.4 },
				{ 0.8095, 	0.9048, 	0.4 },
				{ 0.8254, 	0.9127, 	0.4 },
				{ 0.8413, 	0.9206, 	0.4 },
				{ 0.8571, 	0.9286, 	0.4 },
				{ 0.873, 	0.9365, 	0.4 },
				{ 0.8889, 	0.9444, 	0.4 },
				{ 0.9048, 	0.9524, 	0.4 },
				{ 0.9206, 	0.9603, 	0.4 },
				{ 0.9365, 	0.9683, 	0.4 },
				{ 0.9524, 	0.9762, 	0.4 },
				{ 0.9683, 	0.9841, 	0.4 },
				{ 0.9841, 	0.9921, 	0.4 },
				{ 1.0, 	1.0, 	0.4 }
			};
	}
//-------------------------------------------------------
	public void setWinter()
	{
		d = new double[][]{
				{ 0.0, 	0.0, 	1.0 },
				{ 0.0, 	0.0159, 	0.9921 },
				{ 0.0, 	0.0317, 	0.9841 },
				{ 0.0, 	0.0476, 	0.9762 },
				{ 0.0, 	0.0635, 	0.9683 },
				{ 0.0, 	0.0794, 	0.9603 },
				{ 0.0, 	0.0952, 	0.9524 },
				{ 0.0, 	0.1111, 	0.9444 },
				{ 0.0, 	0.127, 	0.9365 },
				{ 0.0, 	0.1429, 	0.9286 },
				{ 0.0, 	0.1587, 	0.9206 },
				{ 0.0, 	0.1746, 	0.9127 },
				{ 0.0, 	0.1905, 	0.9048 },
				{ 0.0, 	0.2063, 	0.8968 },
				{ 0.0, 	0.2222, 	0.8889 },
				{ 0.0, 	0.2381, 	0.881 },
				{ 0.0, 	0.254, 	0.873 },
				{ 0.0, 	0.2698, 	0.8651 },
				{ 0.0, 	0.2857, 	0.8571 },
				{ 0.0, 	0.3016, 	0.8492 },
				{ 0.0, 	0.3175, 	0.8413 },
				{ 0.0, 	0.3333, 	0.8333 },
				{ 0.0, 	0.3492, 	0.8254 },
				{ 0.0, 	0.3651, 	0.8175 },
				{ 0.0, 	0.381, 	0.8095 },
				{ 0.0, 	0.3968, 	0.8016 },
				{ 0.0, 	0.4127, 	0.7937 },
				{ 0.0, 	0.4286, 	0.7857 },
				{ 0.0, 	0.4444, 	0.7778 },
				{ 0.0, 	0.4603, 	0.7698 },
				{ 0.0, 	0.4762, 	0.7619 },
				{ 0.0, 	0.4921, 	0.754 },
				{ 0.0, 	0.5079, 	0.746 },
				{ 0.0, 	0.5238, 	0.7381 },
				{ 0.0, 	0.5397, 	0.7302 },
				{ 0.0, 	0.5556, 	0.7222 },
				{ 0.0, 	0.5714, 	0.7143 },
				{ 0.0, 	0.5873, 	0.7063 },
				{ 0.0, 	0.6032, 	0.6984 },
				{ 0.0, 	0.619, 	0.6905 },
				{ 0.0, 	0.6349, 	0.6825 },
				{ 0.0, 	0.6508, 	0.6746 },
				{ 0.0, 	0.6667, 	0.6667 },
				{ 0.0, 	0.6825, 	0.6587 },
				{ 0.0, 	0.6984, 	0.6508 },
				{ 0.0, 	0.7143, 	0.6429 },
				{ 0.0, 	0.7302, 	0.6349 },
				{ 0.0, 	0.746, 	0.627 },
				{ 0.0, 	0.7619, 	0.619 },
				{ 0.0, 	0.7778, 	0.6111 },
				{ 0.0, 	0.7937, 	0.6032 },
				{ 0.0, 	0.8095, 	0.5952 },
				{ 0.0, 	0.8254, 	0.5873 },
				{ 0.0, 	0.8413, 	0.5794 },
				{ 0.0, 	0.8571, 	0.5714 },
				{ 0.0, 	0.873, 	0.5635 },
				{ 0.0, 	0.8889, 	0.5556 },
				{ 0.0, 	0.9048, 	0.5476 },
				{ 0.0, 	0.9206, 	0.5397 },
				{ 0.0, 	0.9365, 	0.5317 },
				{ 0.0, 	0.9524, 	0.5238 },
				{ 0.0, 	0.9683, 	0.5159 },
				{ 0.0, 	0.9841, 	0.5079 },
				{ 0.0, 	1.0, 	0.5 }
			};
	}	
//-------------------------------------------------------
	public void getRGB(double alpha, RGB rgb)
	{

		double d1,d2,d3;
		double d1a,d2a,d3a;
		double d1b,d2b,d3b;
		int    index1,index2;

		if (alpha==0){
			d1=d[0][0];
			d2=d[0][1];
			d3=d[0][2];
		}
		else if (alpha==1){
			d1=d[rowNumber-1][0];
			d2=d[rowNumber-1][1];
			d3=d[rowNumber-1][2];
		}
		else{
			index1=(int)(alpha*(rowNumber-1));
			index2=index1+1;
			
			d1a=d[index1][0];
			d2a=d[index1][1];
			d3a=d[index1][2];

			d1b=d[index2][0];
			d2b=d[index2][1];
			d3b=d[index2][2];

			d1=(d1a+d1b)/2;
			d2=(d2a+d2b)/2;
			d3=(d3a+d3b)/2;
		}
	
		rgb.setR( (float) d1);
		rgb.setG( (float) d2);
		rgb.setB( (float) d3);
	}	
//-------------------------------------------------------
} // end class colorMap
/////////////////////////////////////////////////////////
class RGB
{
	private float R,G,B;
//-------------------------------------------------------
	public void setR(float value) {this.R = value;}
	public void setG(float value) {this.G = value;}
	public void setB(float value) {this.B = value;}
	public float getR() { return R;}
	public float getG() { return G;}
	public float getB() { return B;}
//-------------------------------------------------------
} //end class RGB	
/////////////////////////////////////////////////////////
