package gov.nasa.jpl.issm;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.RelativeLayout;
import android.widget.SeekBar;
import android.widget.TextView;
import android.widget.SeekBar.OnSeekBarChangeListener;

public class SliderMenu extends RelativeLayout{

	private SeekBar frictionBar;
	private SeekBar tempBar;
	private SeekBar seaLevelBar;
	private TextView fric, temp, sealvl;
	private int friction, temperature, sealevel;
	final int OFFSET = 10;
	final int MINIMUM = 90;
	View view;
	public SliderMenu(Context context) {
		super(context);
		LayoutInflater mInflater = (LayoutInflater)context.getSystemService(Context.LAYOUT_INFLATER_SERVICE);
		if( mInflater != null)
		{
			view = mInflater.inflate(R.layout.settingsmenu, this, true);
		}
		initialize();
	}
	public void initialize()
	{
		frictionBar = (SeekBar) this.findViewById(R.id.frictionBar);
		tempBar = (SeekBar) this.findViewById(R.id.tempBar);
		seaLevelBar = (SeekBar) this.findViewById(R.id.sealvlBar);
		fric = (TextView) this.findViewById(R.id.fric);
    	temp  = (TextView) this.findViewById(R.id.temp);
    	sealvl   = (TextView) this.findViewById(R.id.sealvl);
    	tempBar.setVisibility(INVISIBLE);
    	seaLevelBar.setVisibility(INVISIBLE);
    	temp.setVisibility(INVISIBLE);
    	sealvl.setVisibility(INVISIBLE);
    	friction = MINIMUM + OFFSET;
    	temperature = MINIMUM + OFFSET;
    	sealevel = MINIMUM + OFFSET;
    	setListenner();
	}
	private void setListenner()
	{
		frictionBar.setOnSeekBarChangeListener(new OnSeekBarChangeListener()
        {
                public void onProgressChanged(SeekBar seekBar, int progress,boolean fromUser)
                {
                		
                        friction = progress + OFFSET;
                        fric.setText("Friction: " + friction + "%");
                }

	            @Override
	            public void onStartTrackingTouch(SeekBar seekBar) {}
	
	            @Override
	            public void onStopTrackingTouch(SeekBar seekBar) {}
        });
        tempBar.setOnSeekBarChangeListener(new OnSeekBarChangeListener()
        {
                public void onProgressChanged(SeekBar seekBar, int progress,boolean fromUser)
                {
	                	
                        temperature = progress + OFFSET;
                        temp.setText("Temperature: " + temperature + "%");
                }

	            @Override
	            public void onStartTrackingTouch(SeekBar seekBar) {}
	
	            @Override
	            public void onStopTrackingTouch(SeekBar seekBar) {}
        });
        seaLevelBar.setOnSeekBarChangeListener(new OnSeekBarChangeListener()
        {
                public void onProgressChanged(SeekBar seekBar, int progress,boolean fromUser)
                {
	                	
                        sealevel = progress + OFFSET;
                        sealvl.setText("Sea Level: " + sealevel + "%");
                }

	            @Override
	            public void onStartTrackingTouch(SeekBar seekBar) {}
	
	            @Override
	            public void onStopTrackingTouch(SeekBar seekBar) {}
        });
	}
	public int getFric() {return friction;}
	public int getTemp() {return temperature;}
	public int getSea()  {return sealevel;}
}
