package gov.nasa.jpl.issm;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.view.MotionEvent;
import android.view.View;
/////////////////////////////////////////////////////////////
public class ColorBar extends View
{
	Paint paint = new Paint();
	Paint textpaint = new Paint();
	//coordinate of the colorbar
    private int width = 30;
	private int start_x = 10;
	private int start_y = 30;
	private int end_y = 0;
	boolean touch;
	final int MAX_SCALING =255;
	double [][] colorBuffer;
    public ColorBar(Context context)
    {
        super(context);
        setWillNotDraw(false);
        paint.setStrokeWidth(5);
		textpaint.setColor(Color.WHITE);
        textpaint.setTextSize(20);
        touch = false;
    }
//----------------------------------------------------------------    
    //change the color map
    public void setColorMap(ColorMap colorMap)
    {
    	this.colorBuffer = colorMap.getColorBuffer();
    }
//----------------------------------------------------------------        
    @Override
    public void onDraw(Canvas canvas) 
    {
    	int r,g,b;
    	int y = start_y;
    	for(int i = 0; i < 64; i++ )
    	{  	
    		r =  Math.round((float)colorBuffer[i][0]*MAX_SCALING);
    		g =  Math.round((float)colorBuffer[i][1]*MAX_SCALING);
    		b =  Math.round((float)colorBuffer[i][2]*MAX_SCALING);
    		paint.setColor(Color.argb(MAX_SCALING, r, g, b));
    		canvas.drawLine(start_x, y, start_x+width, y, paint);
    		
    		if(i == 60)  canvas.drawText("_0.0", start_x+width, y, textpaint);
    		if(i == 48) canvas.drawText("_0.2", start_x+width, y, textpaint);
    		if(i == 36) canvas.drawText("_0.4", start_x+width, y, textpaint);
    		if(i == 24) canvas.drawText("_0.6", start_x+width, y, textpaint);
    		if(i == 12) canvas.drawText("_0.8", start_x+width, y, textpaint);
    		if(i == 0) canvas.drawText("_1.0", start_x+width, y, textpaint);
    		
    		y+=5;
    	}
    	
    	end_y = y;
    }
//----------------------------------------------------------------        
    //allow user to move color bar around
    @Override
    public boolean onTouchEvent (MotionEvent event)
    {

	      if (event.getAction() == MotionEvent.ACTION_DOWN) 
	      {    
	    	  int x = (int) event.getX();
	    	  int y = (int) event.getY(); 
	    	  if(x >= start_x && x <= start_x+width && y >= start_y && y <= end_y)
	    		  touch = true;
	      } 
	      else if (event.getAction() == MotionEvent.ACTION_MOVE) 
	      {
	    	 if(touch)
	    	 {
	    		 start_x = (int) event.getX();
	    		 start_y = (int) event.getY(); 
	    	 }
	    	 invalidate();
	
	      } 
	      else if (event.getAction() == MotionEvent.ACTION_UP) 
	      {
	    	  touch = false;
	      }
	      return true;
    }
//----------------------------------------------------------------        
}
////////////////////////////////////////////////////////////////////////////