#!/bin/bash

#version of metis
version=`echo *.tar.gz | sed 's/\.tar\.gz//g' | sed 's/metis-//g'`
echo $version

#Some cleanup
rm -rf install metis-$version

#Create install directories
mkdir install

#Untar 
tar -zxvf  metis-$version.tar.gz

#Move metis into install directory
mv metis-$version/* install
rm -rf metis-$version

#Apply patches
cd install 
patch -R Makefile ../Makefile.patch
patch -R Makefile.in ../Makefile.in.patch
patch -R Lib/metis.h ../metis.h.patch
patch Lib/Makefile ../lib_Makefile.patch
exit

#Compile metis
make

#Patch proto.h
patch Lib/proto.h ../proto.h.patch
