/*
 * UpdateElementsTransient:
 */

#include "../../../Container/Container.h"
#include "../../../toolkits/toolkits.h"
#include "../../../io/io.h"
#include "../../../modules/modules.h"
#include "../../../EnumDefinitions/EnumDefinitions.h"
#include "../../../classes/objects/objects.h"
#include "../../../shared/shared.h"
#include "../../MeshPartitionx/MeshPartitionx.h"
#include "../../../include/include.h"
#include "../ModelProcessorx.h"

void	UpdateElementsTransient(Elements* elements, Parameters* parameters,IoModel* iomodel,int analysis_counter,int analysis_type){

	bool        isgl;
	int         migration_style;
	int         i,numberofvertices;
	IssmDouble  rho_ice,rho_water;
	IssmDouble *phi   = NULL;

	/*Fetch data needed*/
	iomodel->Constant(&isgl,TransientIsgroundinglineEnum);
	iomodel->Constant(&migration_style,GroundinglineMigrationEnum);

	if(isgl==1 && migration_style==SubelementMigrationEnum){

		/*get parameters and constants: */
		parameters->FindParam(&rho_ice,MaterialsRhoIceEnum);
		parameters->FindParam(&rho_water,MaterialsRhoWaterEnum);
		iomodel->Constant(&numberofvertices,MeshNumberofverticesEnum);
		iomodel->FetchData(2,ThicknessEnum,BathymetryEnum);

		/*Create phi vector */
		phi=xNew<IssmDouble>(numberofvertices);
		for (i=0;i<numberofvertices;i++){
			if(iomodel->my_vertices[i]){
				phi[i] = iomodel->Data(ThicknessEnum)[i] + rho_water/rho_ice * iomodel->Data(BathymetryEnum)[i];
			}
		}

		/*Update elements: */
		for(i=0;i<elements->Size();i++){
			Element* element=dynamic_cast<Element*>(elements->GetObjectByOffset(i));
			element->InputUpdateFromVector(phi,GLlevelsetEnum,VertexEnum);
		}

		/*Free ressources:*/
		xDelete<IssmDouble>(phi);
	}
}
