function ispresent=waitonlock(md)
%WAITONLOCK - wait for a file
%
%   This routine will return when a file named 'filename' is written to disk.
%   If the time limit given in input is exceeded, return 0
%
%   Usage:
%      flag=waitonlock(md)

%Return if waitonlock < 0 (no need to wait)

%Get filename (lock file) and options
executionpath = md.cluster.executionpath;
timelimit     = md.settings.waitonlock;
filename      = [executionpath '/' md.private.runtimename '/' md.miscellaneous.name '.lock'];
cluster       = md.cluster;

%If we are using the generic cluster in interactive mode, job is already complete
if isa(cluster,'generic') & cluster.interactive
	%We are in interactive mode, no need to check for job completion
	ispresent=1;
	return;
end

%initialize time and file presence test flag
time=0; ispresent=0;
disp(['waiting for ' filename ' hold on... (Ctrl+C to exit)'])

%prepare command if the job is not running on the local machine
if ~strcmpi(oshostname(),cluster),
	login = cluster.login;
	port  = 0;
	if isprop(cluster,'port') 
		port = cluster.port;
	end
	if port,
		command = ['ssh -l ' login ' -p ' num2str(port) ' localhost " [ -f ' filename '  ]" 2>/dev/null'];
	else
		command = ['ssh -l ' login ' ' cluster.name ' " [ -f ' filename '  ]" 2>/dev/null'];
	end
end

%loop till file .lock exist or time is up
while (ispresent==0 & time<timelimit)
	if strcmpi(oshostname(),cluster),
		ispresent=exist(filename,'file');
		pause(1);
		time=time+1/60;
	else
		pause(10);
		fprintf('\rchecking for job completion (time = %3.2f min)    ',time);
		ispresent=~system(command); if ispresent, fprintf('\n'); end
		time=time+10/60;
	end
end

%build output
if (time>timelimit),
	disp('Time limit exceeded. Increase md.settings.waitonlock');
	disp('The results must be loaded manually with md=loadresultsfromcluster(md).');
	error(['waitonlock error message: time limit exceeded']);
end
