import numpy as npy

try:
	import pylab as p
except ImportError:
	print "could not import pylab, matplotlib has not been installed, no plotting capabilities enabled"

#from pairoptions import *
from plotoptions import plotoptions
from plot_manager import plot_manager
from math import ceil, sqrt

def plotmodel(md,*args):
	'''
	at command prompt, type 'plotdoc' for additional documentation
	'''

	#First process options 
	options=plotoptions(*args)

	#get number of subplots
	subplotwidth=ceil(sqrt(options.numberofplots))
	
	#Get figure number and number of plots
	figurenumber=options.figurenumber
	numberofplots=options.numberofplots

	#if nlines and ncols specified, then bypass
	if options.list[0].exist('nlines'):
		nlines=options.list[0].getfieldvalue('nlines')
		nl=True
	else:
		nlines=npy.ceil(numberofplots/subplotwidth)
		nl=False
	
	if options.list[0].exist('ncols'):
		ncols=options.list[0].getfieldvalue('ncols')
		nc=True
	else:
		ncols=subplotwidth
		nc=False
	
	#check that nlines and ncols were given at the same time!
	if not nl==nc:
		raise StandardError('error: nlines and ncols need to be specified together, or not at all')
	
	
	#Go through plots
	if numberofplots:
		
		#Create figure
		#plots will be visible by default if ipython is run in interactive mode (invoked by ipython --pylab)
		#handling the 'visible' option will need some check on whether ipython is currently in interactive or non-interactive mode

		#if figsize specified
		if options.list[0].exist('figsize'):
			figsize=options.list[0].getfieldvalue('figsize')
			p.figure(figurenumber,figsize=figsize)
		else:
			p.figure(figurenumber)
			
		#try:
		for i in xrange(numberofplots):
			plot_manager(options.list[i].getfieldvalue('model',md),options.list[i],subplotwidth,nlines,ncols,i+1)
		#except StandardError:
		#	print 'error in plot_manager'
	else:
		raise StandardError('plotmodel error message: no output data found.')
