#module imports
import numpy
from fielddisplay import fielddisplay
from EnumDefinitions import *
from checkfield import *
from WriteData import *

class initialization(object):
	"""
	INITIALIZATION class definition

	   Usage:
	      initialization=initialization();
	"""

	#properties
	def __init__(self):
		# {{{ Properties
		
		self.vx            = float('NaN')
		self.vy            = float('NaN')
		self.vz            = float('NaN')
		self.vel           = float('NaN')
		self.pressure      = float('NaN')
		self.temperature   = float('NaN')
		self.surfacetemp   = float('NaN')
		self.basaltemp     = float('NaN')
		self.watercolumn   = float('NaN')
		self.waterfraction = float('NaN')

		#set defaults
		self.setdefaultparameters()

		#}}}
	def __repr__(self):
		# {{{ Display
		string='   initial field values:'

		string="%s\n%s"%(string,fielddisplay(self,'vx','x component of velocity'))
		string="%s\n%s"%(string,fielddisplay(self,'vy','y component of velocity'))
		string="%s\n%s"%(string,fielddisplay(self,'vz','z component of velocity'))
		string="%s\n%s"%(string,fielddisplay(self,'vel','velocity norm'))
		string="%s\n%s"%(string,fielddisplay(self,'pressure','pressure field'))
		string="%s\n%s"%(string,fielddisplay(self,'temperature','temperature in Kelvins'))
		string="%s\n%s"%(string,fielddisplay(self,'surfacetemp','surface temperature in Kelvins'))
		string="%s\n%s"%(string,fielddisplay(self,'basaltemp','basal temperature in Kelvins'))
		string="%s\n%s"%(string,fielddisplay(self,'watercolumn','thickness of subglacial water'))
		string="%s\n%s"%(string,fielddisplay(self,'waterfraction','fraction of water in the ice'))

		return string
		#}}}
		
	def setdefaultparameters(self):
		# {{{setdefaultparameters
		return self
	#}}}

	def checkconsistency(self,md,solution,analyses):    # {{{
		if DiagnosticHorizAnalysisEnum() in analyses:
			if not numpy.any(numpy.logical_or(numpy.isnan(md.initialization.vx),numpy.isnan(md.initialization.vy))):
				md = checkfield(md,'initialization.vx','NaN',1,'size',[md.mesh.numberofvertices])
				md = checkfield(md,'initialization.vy','NaN',1,'size',[md.mesh.numberofvertices])
		if PrognosticAnalysisEnum() in analyses:
			md = checkfield(md,'initialization.vx','NaN',1,'size',[md.mesh.numberofvertices])
			md = checkfield(md,'initialization.vy','NaN',1,'size',[md.mesh.numberofvertices])
		if HydrologyAnalysisEnum() in analyses:
			md = checkfield(md,'initialization.watercolumn','NaN',1,'size',[md.mesh.numberofvertices])
		if BalancethicknessAnalysisEnum() in analyses:
			md = checkfield(md,'initialization.vx','NaN',1,'size',[md.mesh.numberofvertices])
			md = checkfield(md,'initialization.vy','NaN',1,'size',[md.mesh.numberofvertices])
			#Triangle with zero velocity
			if numpy.any(numpy.logical_and(numpy.sum(numpy.abs(md.initialization.vx[md.mesh.elements-1]),axis=1)==0,\
			                               numpy.sum(numpy.abs(md.initialization.vy[md.mesh.elements-1]),axis=1)==0)):
				md.checkmessage("at least one triangle has all its vertices with a zero velocity")
		if ThermalAnalysisEnum() in analyses:
			md = checkfield(md,'initialization.vx','NaN',1,'size',[md.mesh.numberofvertices])
			md = checkfield(md,'initialization.vy','NaN',1,'size',[md.mesh.numberofvertices])
			md = checkfield(md,'initialization.vz','NaN',1,'size',[md.mesh.numberofvertices])
			md = checkfield(md,'initialization.pressure','NaN',1,'size',[md.mesh.numberofvertices])
		if (EnthalpyAnalysisEnum() in analyses and md.thermal.isenthalpy) or solution==EnthalpySolutionEnum():
			md = checkfield(md,'initialization.waterfraction','>=',0,'size',[md.mesh.numberofvertices])

		return md
	# }}}

	def marshall(self,fid):    # {{{
		WriteData(fid,'data',self.vx,'format','DoubleMat','mattype',1,'enum',VxEnum())
		WriteData(fid,'data',self.vy,'format','DoubleMat','mattype',1,'enum',VyEnum())
		WriteData(fid,'data',self.vz,'format','DoubleMat','mattype',1,'enum',VzEnum())
		WriteData(fid,'data',self.pressure,'format','DoubleMat','mattype',1,'enum',PressureEnum())
		WriteData(fid,'data',self.temperature,'format','DoubleMat','mattype',1,'enum',TemperatureEnum())
		WriteData(fid,'data',self.watercolumn,'format','DoubleMat','mattype',1,'enum',WatercolumnEnum())
		WriteData(fid,'data',self.waterfraction,'format','DoubleMat','mattype',1,'enum',WaterfractionEnum())
	# }}}

