#module imports
from fielddisplay import fielddisplay
from WriteData import *

class debug(object):
	"""
	DEBUG class definition

	   Usage:
	      debug=debug();
	"""

	#properties
	def __init__(self):
		# {{{ Properties
		self.valgrind  = False
		self.gprof     = False
		self.profiling = False
		
		#set defaults
		self.setdefaultparameters()

		#}}}
	def __repr__(self):
		# {{{ Display
		string="   debug parameters:"

		string="%s\n%s"%(string,fielddisplay(self,"valgrind","use Valgrind to debug (0 or 1)"))
		string="%s\n%s"%(string,fielddisplay(self,"gprof","use gnu-profiler to find out where the time is spent"))
		string="%s\n%s"%(string,fielddisplay(self,'profiling','enables profiling (memory, flops, time)'))
		return string
		#}}}
		
	def setdefaultparameters(self):
		# {{{setdefaultparameters
		return self
	#}}}

	def marshall(self,fid):    # {{{
		WriteData(fid,'object',self,'fieldname','profiling','format','Boolean')
	# }}}

