package com.example.issm;

import android.app.Activity;
import android.net.Uri;
import android.os.Bundle;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.Button;
import android.widget.ImageButton;
import android.widget.PopupWindow;
import android.content.Intent;
/////////////////////////////////////////////////////////////////////////// 
public class MenuPage extends Activity
{
	ISSM issm = new ISSM();
	private String issmFolder; 
//------------------------------------------------------------------------	
	public void onCreate(Bundle icicle)
	{
		super.onCreate(icicle);
		setContentView(R.layout.menupage);		
		Bundle map = getIntent().getExtras();
        {
        	if(map!= null)
        	{
        		issmFolder = map.getString("pathToFile");
        	}
        }
        //start the core implementation of ISSM
	    ImageButton start = (ImageButton) findViewById(R.id.start);		
		start.setOnClickListener(new View.OnClickListener() 
		{
			public void onClick(View v) 
			{
				Intent i = new Intent(MenuPage.this, ISSM.class);
				i.putExtra("pathToFile", issmFolder);
		        startActivity(i);
			}
		});
		// navigate to youtube video
		ImageButton video = (ImageButton) findViewById(R.id.video);		
		video.setOnClickListener(new View.OnClickListener() 
		{
			public void onClick(View v) 
			{
				String url = "http://www.youtube.com/watch?v=KlDO0C8r_ws";
				Intent i = new Intent(Intent.ACTION_VIEW);
				i.setData(Uri.parse(url));
		        startActivity(i);
			}
		});
		// pop up a text box that contains information about ISSM
		final ImageButton intro = (ImageButton) findViewById(R.id.intro);	
		intro.setOnClickListener(new View.OnClickListener() 
		{
			public void onClick(View v)
			{
				LayoutInflater layoutInflater = (LayoutInflater)getBaseContext().getSystemService(LAYOUT_INFLATER_SERVICE);  
				View popupView = layoutInflater.inflate(R.layout.popuptext, null);  
				final PopupWindow popupWindow = new PopupWindow( popupView, 400,600, true);
				popupWindow.showAtLocation(popupView, Gravity.CENTER, 0, 0);
				Button dismiss = (Button)popupView.findViewById(R.id.dismiss);
	            dismiss.setOnClickListener(new Button.OnClickListener()
	            {
	            	public void onClick(View v)
	            	{
	            		popupWindow.dismiss();
	            	}
	            });
			}
		});
		//navigate to website
		ImageButton visitus = (ImageButton) findViewById(R.id.visitus);		
		visitus.setOnClickListener(new View.OnClickListener() 
		{
			public void onClick(View v) 
			{
				String url = "http://issm.jpl.nasa.gov/";
				Intent i = new Intent(Intent.ACTION_VIEW);
				i.setData(Uri.parse(url));
		        startActivity(i);
			}
		});
	}
//-------------------------------------------------------------------------------------	
}
///////////////////////////////////////////////////////////////////////////////////////// 