/*!\file: elements.h
 * \brief prototypes for elements.h
 */ 

#ifndef _SHARED_ELEMENTS_H_
#define _SHARED_ELEMENTS_H_

#include "../../classes/objects/objects.h"
#include "../../Container/Container.h"
class ElementMatrix;
class ElementVector;

IssmDouble Paterson(IssmDouble temperature);
IssmDouble Arrhenius(IssmDouble temperature,IssmDouble depth,IssmDouble n);
IssmDouble PddSurfaceMassBlance(IssmDouble* monthlytemperatures,  IssmDouble* monthlyprec, IssmDouble* pdds, IssmDouble* pds, 
				IssmDouble signorm, IssmDouble yts, IssmDouble h, IssmDouble s, IssmDouble rho_ice, IssmDouble rho_water);
void ComputeDelta18oTemperaturePrecipitation(IssmDouble Delta18oSurfacePresent, IssmDouble Delta18oSurfaceLgm, IssmDouble Delta18oSurfaceTime,
				     IssmDouble Delta18oPresent, IssmDouble Delta18oLgm, IssmDouble Delta18oTime, 
				     IssmDouble* PrecipitationsPresentday,
				     IssmDouble* TemperaturesLgm, IssmDouble* TemperaturesPresentday, 
					     IssmDouble* monthlytemperaturesout, IssmDouble* monthlyprecout);
void   GetVerticesCoordinates(IssmDouble* xyz,  Node** nodes, int numvertices);
int    GetNumberOfDofs( Node** nodes,int numnodes,int setenum,int approximation_enum);
int*   GetLocalDofList( Node** nodes,int numnodes,int setenum,int approximation_enum);
int*   GetGlobalDofList(Node** nodes,int numnodes,int setenum,int approximation_enum);

#ifdef _HAVE_DIAGNOSTIC_
void   CoordinateSystemTransform(IssmDouble** ptransform,Node** nodes,int numnodes,int* cs_array);
void   TransformInvStiffnessMatrixCoord(ElementMatrix* Ke,Node** nodes,int numnodes,int cs_enum);
void   TransformInvStiffnessMatrixCoord(ElementMatrix* Ke,Node** nodes,int numnodes,int* cs_array);
void   TransformStiffnessMatrixCoord(ElementMatrix* Ke,Node** nodes,int numnodes,int cs_enum);
void   TransformStiffnessMatrixCoord(ElementMatrix* Ke,Node** nodes,int numnodes,int* cs_array);
void   TransformLoadVectorCoord(ElementVector* pe,Node** nodes,int numnodes,int cs_enum);
void   TransformLoadVectorCoord(ElementVector* pe,Node** nodes,int numnodes,int* cs_array);
void   TransformSolutionCoord(IssmDouble* solution,Node** nodes,int numnodes,int cs_enum);
void   TransformSolutionCoord(IssmDouble* solution,Node** nodes,int numnodes,int* cs_array);
#endif

/*Print arrays*/
void printarray(IssmPDouble* array,int lines,int cols=1);
void printarray(int* array,int lines,int cols=1);
void printarray(bool* array,int lines,int cols=1);
void printsparsity(IssmPDouble* array,int lines,int cols=1);
void printbinary(int n);
#endif //ifndef _SHARED_ELEMENTS_H_
