/*!\file:  Exp.cpp
 * \brief Exp.cpp: write the vertex coordinates defined in a domain 
 * outline from Argus (.exp file). The first contour in the file is for 
 * the outside domain outline. 
 */
#include <stdio.h>
#include "../Alloc/alloc.h"
#include "../../include/include.h"
#include "../Exceptions/exceptions.h"
#include "../../Container/DataSet.h"
#include "../../classes/objects/Contour.h"

int ExpWrite(int nprof,int* profnvertices,double** pprofx,double** pprofy,char* domainname){/*{{{*/

	/*I/O: */
	FILE* fid=NULL;

	/*open domain outline file for writing: */
	if((fid=fopen(domainname,"w"))==NULL) _error_("could not open domain file " << domainname); 

	/*Start writing profiles: */
	for(int counter=0;counter<nprof;counter++){

		/*Write header: */
		fprintf(fid,"## Name:%s\n",domainname);
		fprintf(fid,"## Icon:0\n");
		fprintf(fid,"# Points Count	Value\n");
		fprintf(fid,"%u %s\n",profnvertices[counter]  ,"1.");
		fprintf(fid,"# X pos	Y pos\n");

		/*Write vertices: */
		for(int i=0;i<profnvertices[counter];i++){
			fprintf(fid,"%lf\t%lf\n",pprofx[counter][i],pprofy[counter][i]);
		}

		/*Write blank line: */
		if(counter<nprof-1) fprintf(fid,"\n");
	}

	/*close Exp file: */
	fclose(fid);

	return 1;
}/*}}}*/
int ExpWrite(DataSet* contours,char* domainname){/*{{{*/

	/*I/O: */
	FILE* fid=NULL;
	Contour<double>* contour = NULL;

	/*open domain outline file for writing: */
	if((fid=fopen(domainname,"w"))==NULL) _error_("could not open domain file " << domainname); 

	for(int counter=0;counter<contours->Size();counter++){
		contour=(Contour<double>*)contours->GetObjectByOffset(counter);

		/*Write header: */
		fprintf(fid,"## Name:%s\n",domainname);
		fprintf(fid,"## Icon:0\n");
		fprintf(fid,"# Points Count	Value\n");
		fprintf(fid,"%u %s\n",contour->nods  ,"1.");
		fprintf(fid,"# X pos	Y pos\n");

		/*Write vertices: */
		for(int i=0;i<contour->nods;i++){
			fprintf(fid,"%lf\t%lf\n",contour->x[i],contour->y[i]);
		}

		/*Write blank line: */
		if(counter<contours->Size()-1) fprintf(fid,"\n");
	}

	/*close Exp file: */
	fclose(fid);

	return 1;
}/*}}}*/
