/*\file Shp2Exp.c
 *\brief: shp to exp file conversion mex module.
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "./Shp2Exp.h"

void Shp2ExpUsage(void){/*{{{*/
	_pprintLine_("Shp2Exp - shp to exp file conversion module:");
	_pprintLine_("");
	_pprintLine_("   This module converts a file from shp to exp format.");
	_pprintLine_("");
	_pprintLine_("   Usage:");
	_pprintLine_("      [ret]=Shp2Exp(filshp,filexp,sgn,'param name',param,...);");
	_pprintLine_("");
	_pprintLine_("      filshp      file name of shp file to be read (char, extension optional)");
	_pprintLine_("      filexp      file name of exp file to be written (char)");
	_pprintLine_("");
	_pprintLine_("      ret         return code (non-zero for warning)");
	_pprintLine_("");
	_pprintLine_("   Examples:");
	_pprintLine_("      [ret]=Shp2Exp('file.shp','file.exp');");
	_pprintLine_("");
}/*}}}*/
WRAPPER(Shp2Exp){

	int i,verbose=1;

	/*input: */
	char    *filshp=NULL,*filexp=NULL;

	/* output: */
	int     iret=0;

	#ifndef _HAVE_SHAPELIB_ //only works if shapelib library has been compiled in.
	_error_("Shapelib not available! Cannot carry out shp file translation!");
	#endif

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	if (nlhs > NLHS) {
		Shp2ExpUsage(); _error_("Shp2Exp usage error");
	}
	if (nrhs < NRHS) {
		Shp2ExpUsage(); _error_("Shp2Exp usage error");
	}

	/*Input datasets: */
	FetchData(&filshp,SHP_IN);
	FetchData(&filexp,EXP_IN);

	/* Run core computations: */
	iret=Shp2Expx(filshp,filexp);

	/*Write data: */
	WriteData(RET_OUT,iret);

	/*Clean-up*/
	xDelete<char>(filexp);
	xDelete<char>(filshp);

	/*end module: */
	MODULEEND();
}
