#!/bin/bash
set -eu

#Some cleanup
rm -rf Dakota
rm -rf src 
rm -rf install 
mkdir src install 

#Download from ISSM server
#$ISSM_DIR/scripts/DownloadExternalPackage.py 'http://issm.jpl.nasa.gov/files/externalpackages/Dakota_5_2.src.tar.gz' 'Dakota_5_2.src.tar.gz'

#Untar 
tar -zxvf Dakota_5_2.src.tar.gz

#Move Dakota to src directory
mv Dakota/* src
rm -rf Dakota

#Apply patches
patch src/src/ParallelLibrary.C ./ParallelLibrary.C.5.2.patch
patch src/src/ParallelLibrary.H ./ParallelLibrary.H.5.2.patch
#patch src/src/NIDRProblemDescDB.C ./NIDRProblemDescDB.C.5.2.patch    #  causes segfault in 5.2
patch src/src/NonDSampling.C ./NonDSampling.C.5.2.patch
patch src/src/NonDLocalReliability.C ./NonDLocalReliability.C.5.2.patch
patch src/src/NonDUnilevelRBDO.C ./NonDUnilevelRBDO.C.5.2.patch    #  source not even used?
patch src/packages/pecos/src/pecos_global_defs.hpp ./pecos_global_defs.hpp.5.2.patch

#Configure dakota
cd src
./configure \
	--prefix="$ISSM_DIR/externalpackages/dakota/install" \
	--without-graphics  \
	--with-pic \
	--disable-mpi \
	--with-plugin \
	--with-blas=/usr/lib64/libblas.so.3.0.3 \
	--with-lapack=/usr/lib64/liblapack.so.3.0.3
cd ..

#Compile and install dakota
cd src 
if [ $# -eq 0 ];
then
	make
	make install
else
	make -j $1
	make -j $1 install
fi
cd ..
