function expwrite(a,filename)
%EXPWRITE - write an Argus file from a structure given in input
%
%   This routine write an Argus file form a structure containing the fields:
%   x and y of the coordinates of the points.
%   The first argument is the structure containing the points coordinates 
%   and the second one the file to be write.
%
%   Usage:
%      expwrite(a,filename)
% 
%   Example:
%      expwrite(coordstruct,'domainoutline.exp')
%
%   See also EXPDOC, EXPREAD, EXPWRITEASVERTICES

%check input variable
if ~isstruct(a),
	error('first argument is not a structure');
end

%Add density if it's not there
if ~isfield(a,'density'),
	for n=1:length(a),
		a(n).density=1;
	end
end

fid=fopen(filename,'w');
for n=1:length(a),
	if(length(a(n).x)~=length(a(n).y)),
		error('contours x and y coordinates must be of identical size');
	end

	if isfield(a,'name'),
		fprintf(fid,'%s%s\n','## Name:',a(n).name);
	else
		fprintf(fid,'%s%s\n','## Name:',filename);
	end

	fprintf(fid,'%s\n','## Icon:0');
	fprintf(fid,'%s\n','# Points Count Value');
	fprintf(fid,'%i %f\n',[length(a(n).x) a(n).density]);
	fprintf(fid,'%s\n','# X pos Y pos');
	fprintf(fid,'%10.10f %10.10f\n',[a(n).x a(n).y]');
	fprintf(fid,'\n');

end
fclose(fid);
