import numpy as npy

def checkplotoptions(md,options):
	'''
	CHECKPLOTOPTIONS - build a structure that holds all plot options

		Usage:
			options=checkplotoptions(md,options)

		See also: PLOTMODEL

		NOTE: not fully implemented yet
	'''


	#units
	if options.exist('unit'):
		if 'km' in options.getfieldvalue('unit','km'):
			options.changefieldvalue('unit',10**-3)
		if '100km' in options.getfieldvalue('unit','100km'):
			options.changefieldvalue('unit',10**-5)
	
	#density
	if options.exist('density'):
		density=options.getfieldvalue('density')
		options.changefieldvalue('density',abs(ceil(density)))
	
	#show section
	if options.exist('showsection'):
		if 'on' in options.getfieldvalue('showsection','on'):
			options.changefieldvalue('showsection',4)
	
	#smooth values
	if options.exist('smooth'):
		if 'on' in options.getfieldvalue('smooth','on'):
			options.changefieldvalue('smooth',0)

	#contouronly values
	if options.exist('contouronly'):
		if 'on' in options.getfieldvalue('contouronly','on'):
			options.changefieldvalue('contouronly',1)

	#colorbar
	if options.exist('colorbar'):
		if 'on' in options.getfieldvalue('colorbar','on'):
			options.changefieldvalue('colorbar',1)
		elif 'off' in options.getfieldvalue('colorbar','off'):
			options.changefieldvalue('colorbar',0)

	#text
	if options.exist('text'):
		#1: textvalue
		textvalues=options.getfieldvalue('text')
		numtext=len(textvalues)

		#2: textweight
		if options.exist('textweight'):
			textweightvalues=options.getfieldvalue('textweight')
		else:
			textweightvalues='n'
		textweightvalues=npy.tile(textweightvalues,numtext)

		#3 textsize
		if options.exist('textsize'):
			textsizevalues=options.getfieldvalue('textsize')
		else:
			textsizevalues=14
		textsizevalues=npy.tile(textsizevalues,numtext)

		#4 textcolor
		if options.exist('textcolor'):
			textcolorvalues=options.getfieldvalue('textcolor')
		else:
			textcolorvalues='k'
		textcolorvalues=npy.tile(textsizevalues,numtext)

		#5 textposition
		if options.exist('textposition'):
			options.getfieldvalue('textposition')
		else:
			raise Exception("plotmodel error message: 'textposition' option is missing")

		#6 textrotation
		if options.exist('textrotation'):
			textrotationvalues=options.getfieldvalue('textrotation')
		else:
			textrotationvalues=0
		textrotationvalues=npy.tile(textrotationvalues,numtext)

		options.changfieldvalue('text',textvalues)
		options.changfieldvalue('textsize',textsizevalues)
		options.changfieldvalue('textweight',textweightvalues)
		options.changfieldvalue('textcolor',textcolorvalues)
		options.changfieldvalue('textposition',textpositionvalues)
		options.changfieldvalue('textrotation',textrotationvalues)

	#expdisp
	expdispvaluesarray=[0,0]
	expstylevaluesarray=[0,0]
	expstylevalues=[0,0]
	if options.exist('expstyle'):
		expstylevalues=options.getfieldvalue('expstyle')
	if options.exist('expdisp'):
		expdispvalues=options.getfieldvalue('expdisp')
		for i in npy.arange(len(expdispvalues)):
			expdispvaluesarray.append(expdispvalues[i])
			if len(expstylevalues)>i+1:
				expstylevaluesarray.append(expstylevalues[i])
			else:
				expstylevaluesarray.append('-k')

	options.changefieldvalue('expstyle',expstylevaluesarray)
	options.changefieldvalue('expdisp',expdispvaluesarray)

	#latlonnumbering
	if options.exist('latlonclick'):
		if 'on' in options.getfieldvalue('latlonclick','on'):
			options.changefieldvalue('latlonclick',1)

	#northarrow
	if options.exist('northarrow'):
		if 'on' in options.getfieldvalue('northarrow','on'):
			#default values
			Lx=max(md.mesh.x)-min(md.mesh.x)
			Ly=max(md.mesh.y)-min(md.mesh.y)
			options.changefieldvalue('northarrow',[min(md.mesh.x)+1./6.*Lx, min(md.mesh.y)+5./6.*Ly, 1./15.*Ly, 0.25, 1./250.*Ly])

	#scale ruler
	if options.exist('scaleruler'):
		if 'on' in options.exist('scaleruler','on'):
			Lx=max(md.mesh.x)-min(md.mesh.x)
			Ly=max(md.mesh.y)-min(md.mesh.y)
			options.changefieldvalue('scaleruler',[min(md.mesh.x)+6./8.*Lx, min(md.mesh.y)+1./10.*Ly, 10**(ceil(log10(Lx)))/5, floor(Lx/100), 5])

	#log scale
	if options.exist('log'):
		if options.exist('caxis'):
			options.changefieldvalue('caxis',log(options.getfieldvalue('caxis'))/log(options.getfieldvalue('log')))
		options.changefieldvalue('cutoff',log(options.getfieldvalue('cutoff',1.5))/log(options.getfieldvalue('log')))

	return options
