function DAKOTA_VERSION=dakotaversion()
%DAKOTAVERSION - recover dakota version number, inside config.h file
%
%   Usage:
%       DAKOTA_VERSION=dakotaversion();

%default
DAKOTA_VERSION='';

configfile=[issmdir() '/config.h'];
if ~exist(configfile,'file'),
	error(['File ' configfile ' not found. Dakota has not been configured yet!']);
end

%go through the file, and recover the line we want
fid=fopen(configfile,'r');
if(fid==-1), error(['could not open file: ' configfile]); end

while(true),
	tline=fgets(fid);
	if ~ischar(tline), break, end
	if  strncmp(tline,'#define DAKOTA_VERSION',22),
		DAKOTA_VERSION=strtrim(strrep(tline(24:end),'"',''));
	end
end
fclose(fid);
