
try:
	import pylab as p
except ImportError:
	print "could not import pylab, matplotlib has not been installed, no plotting capabilities enabled"

from pairoptions import *
from checkplotoptions import checkplotoptions
from plot_mesh import plot_mesh
from processmesh import processmesh
from processdata import processdata
from plot_unit import plot_unit
from applyoptions import applyoptions

def plot_manager(md,options,subplotwidth,nlines,ncols,i):
	'''
	PLOT_MANAGER - distribute the plots called by plotmodel

		Usage:
			plot_manager(md,options,subplotwidth,i);

		See also: PLOTMODEL, PLOT_UNIT
	'''

	#parse options and get a structure of options
	options=checkplotoptions(md,options)
	#print 'options:', options

	#get data to be plotted
	data=options.getfieldvalue('data');

	#figure out if this is a special plot
	if isinstance(data,(str,unicode)):

		# convert string to lower case for a case-insensitive comparison
		if data.lower()=='mesh': 
			plot_mesh(md,options,nlines,ncols,i)
			return
		else:
			print "WARNING: '%s' is not implemented or is not a valid string for option 'data'" % data

	#elif data in vars(md):
	#else:
		#print "'data' not a string, plotting model properties yet to be implemented..."

	#Overlay plot

	#Gridded plot

	#Section plot

	#Profile plot

	#process data and model
	x,y,z,elements,is2d,isplanet=processmesh(md,data,options)
	data2,datatype=processdata(md,data,options)

	#standard plot
	p.subplot(nlines,ncols,i,aspect='equal')

	#plot unit
	plot_unit(x,y,z,elements,data2,is2d,isplanet,datatype,options)

	#apply all options
	applyoptions(md,data2,options)
	
	#ground overlay on kml plot_unit
