import os
from issmdir import *
from MatlabFuncs import *

def dakotaversion():
	"""
	DAKOTAVERSION - recover dakota version number, inside dakota_config.h file
 
	   Usage:
	      DAKOTA_VERSION=dakotaversion();
	"""

	#default
	DAKOTA_VERSION=0

	configfile=os.path.join(issmdir(),'externalpackages','dakota','install','include','dakota_config.h')
	if not os.path.exists(configfile):
		raise RuntimeError("File '%s' not found. Dakota has not been configured yet!" % configfile)

	#go through the file, and recover the line we want
	try:
		fid=open(configfile,'r')
	except IOError as e:
		raise IOerror("could not open file: '%s'" % configfile)

	for tline in fid:
		if strncmp(tline,'#define PACKAGE_VERSION',23):
			DAKOTA_VERSION=tline[24:].replace('"','').strip()
			break

	fid.close()

	return DAKOTA_VERSION

