package com.example.issm;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;

import android.opengl.GLSurfaceView;
import android.os.Bundle;
import android.app.Activity;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.Button;
import android.widget.EditText;
import android.widget.FrameLayout;
import android.widget.SeekBar;
import android.widget.SeekBar.OnSeekBarChangeListener;
import android.widget.TextView;
import android.widget.Toast;


public class ISSM extends Activity implements OnClickListener 
{
	private EditText input;
	private TextView output;
	private DoubleBuffer buff;
	private IssmJni issmNative;
	private String mapName;
	private String issmFolder;
	private int size;
    private GLSurfaceView mGLView;
	private FrameLayout frame;
	private SeekBar bar;
    private TextView /*txtStatus,*/ txtValue;
    private ColorMap colorMap;
    private int alpha;
    private final int MINIMUM = 0;
    private final int OFFSET = 10;
    @Override
  //------------------------------------------------------------------------------------------------    
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Bundle map = getIntent().getExtras();
        {
        	if(map!= null)
        	{
        		mapName = map.getString("map");
        		issmFolder = map.getString("pathToFile");
        	}
        }
        alpha = 90 + OFFSET;
        setContentView(R.layout.activity_issm);
        this.bar  = (SeekBar) findViewById(R.id.seekBar);
        this.txtValue  = (TextView) super.findViewById(R.id.value);
        Button button = (Button) super.findViewById(R.id.button1);
	    frame = (FrameLayout)findViewById(R.id.frame);
        button.setOnClickListener(this);
        bar.setOnSeekBarChangeListener(new OnSeekBarChangeListener()
        {
                public void onProgressChanged(SeekBar seekBar, int progress,boolean fromUser)
                {
        
                        alpha = progress + OFFSET;
                        txtValue.setText("Friction Scaling: " +  alpha + "%");
                }

	            @Override
	            public void onStartTrackingTouch(SeekBar seekBar) {
	                    // TODO Auto-generated method stub
	
	            }
	
	            @Override
	            public void onStopTrackingTouch(SeekBar seekBar) {
	                    // TODO Auto-generated method stub
	
	            }
        });

        
        //load up the ISSM library and create double buffer in java
        //which later on will be pass for native allocation.
        issmNative = new IssmJni();
        this.createModel();
        this.colorMap = new ColorMap();
        buff = ByteBuffer.allocateDirect(size*12*8).order(ByteOrder.nativeOrder()).asDoubleBuffer();
    }
//------------------------------------------------------------------------------------------------    
    public void createModel()
    {
		String solution_type="DiagnosticSolution";
    	String file = "";
    	if( mapName.equals("greenland"))
		{
    		file = "greenland";
		}
    	else file = "antarctica";

    	size = issmNative.createISSMModel(solution_type,issmFolder,file);
    }
//------------------------------------------------------------------------------------------------
    public void fillBuffer()
    {
    	issmNative.solveISSMModel(alpha,buff);
    }
//------------------------------------------------------------------------------------------------  
    public boolean onCreateOptionsMenu(Menu menu)
    {
    	MenuInflater menuInflater = getMenuInflater();
    	menuInflater.inflate(R.menu.issm_menu,menu);
    	
    	return true;
    }
//------------------------------------------------------------------------------------------------
   public boolean onOptionsItemSelected(MenuItem item)
    {
    	switch (item.getItemId())
        {
	        case R.id.menu_about:          
	            Toast.makeText(ISSM.this, "ISSM Application", Toast.LENGTH_SHORT).show();
	            return true;
	 	            
	        case R.id.cl_autumn:
	        	colorMap.setAutumn();
	        	drawFigure();
	        	return true;
	        
	        case R.id.cl_bone:
	        	colorMap.setBone();
	        	drawFigure();
	        	return true;
	        
	        case R.id.cl_cool:
	        	colorMap.setCool();
	        	drawFigure();
	        	return true;
	        	
	        case R.id.cl_copper:
	        	colorMap.setCopper();
	        	drawFigure();
	        	return true;
	        	
	        case R.id.cl_gray:
	        	colorMap.setGray();
	        	drawFigure();
	        	return true;
	        
	        case R.id.cl_hot:
	        	colorMap.setGray();
	        	drawFigure();
	        	return true;
	        
	        case R.id.cl_hsv:
	        	colorMap.setDefault();
	        	drawFigure();
	        	return true;
	        	
	        case R.id.cl_jet:
	        	colorMap.setJet();
	        	drawFigure();
	        	return true;
	        	
	        case R.id.cl_pink:
	        	colorMap.setPink();
	        	drawFigure();
	        	return true;
	        	
	        case R.id.cl_spring:
	        	colorMap.setSpring();
	        	drawFigure();
	        	return true;
	        	
	        case R.id.cl_summer:	
	        	colorMap.setSummer();
	        	drawFigure();
	        	return true;
	        	
	        case R.id.cl_winter:
	        	colorMap.setWinter();
	        	drawFigure();
	        	return true;
	        default:
	        	return super.onOptionsItemSelected(item);
        }
            
    }
//---------------------------------------------------------------------------------   
    public void onClick(View view) 
	{
		this.fillBuffer();
		drawFigure();
	}
//---------------------------------------------------------------------------------- 
    public void drawFigure()
    {
    	frame.removeView(mGLView);
    	mGLView = new MyGLSurfaceView(this, buff, size, colorMap);
    	frame.addView(mGLView);
    }
//-----------------------------------------------------------------------------------    
}
