#!/bin/bash

#Get number of cpus on current platform
NUMCPUS=`grep -c processor /proc/cpuinfo`;

#version of metis
version=`echo *.tar.gz | sed 's/\.tar\.gz//g' | sed 's/metis-//g'`
echo $version

#Some cleanup
rm -rf install metis-$version

#Create install directories
mkdir install

#Untar 
tar -zxvf  metis-$version.tar.gz

#Move metis into install directory
mv metis-$version/* install
rm -rf metis-$version

#Platform specific stuff: 
./configure.sh

#Apply patches
cd install 
patch -R Makefile ../Makefile.patch
patch -R Makefile.in ../Makefile.in.patch
patch -R Lib/metis.h ../metis.h.patch
patch Lib/Makefile ../lib_Makefile.patch

#Compile metis
make  -j $NUMCPUS

#Patch proto.h
patch Lib/proto.h ../proto.h.patch
