#!/bin/bash
set -eu

#Some cleanup
rm -rf src
rm -rf install
rm -rf gdal-1.9.2
mkdir src install

#Download from ISSM server
$ISSM_DIR/scripts/DownloadExternalPackage.py 'http://issm.jpl.nasa.gov/files/externalpackages/gdal-1.9.2.tar.gz' 'gdal-1.9.2.tar.gz'

#Untar 
tar -zxvf  gdal-1.9.2.tar.gz

#Move gdal into src directory
mv gdal-1.9.2/* src
rm -rf gdal-1.9.2

#Configure gdal
cd src
./configure \
	--prefix="$ISSM_DIR/externalpackages/gdal/install" \
	--with-python \
	--with-netcdf=no \
	--with-static-proj4=".//local/lib/libproj4.a" \
	--without-hdf5

#Compile and install gdal
if [ $# -eq 0 ]; then
	make
else
	make -j $1
fi
make install
