#!/bin/bash
#This bash script calls the nightlyrun.m matlab file to run our nightly test decks. 
#It then processes the results and sends an email to the Ice developpers.

#Recover package for which we run nightly.
package=$1;
echo $package

#Some functions 
function today_date {
suffix=`date | awk '{printf("%s-%s-%s",$2,$3,$6);}'` 
echo $suffix;
}

#Figure out today's date
export today=`today_date`;
export host_name=`hostname`;

#create ISSM variables
export ISSM_DIR="/u/wilkes-r1b/morlighe/svn/issm/trunk/cron/trunk"
export ISSM_ARCH=linux-gnu-amd64
source $ISSM_DIR/etc/environment.sh
export ISSM_RELEASE="issm";

#Erase previous code
rm -rf trunk

#Fetch svn code
svn checkout http://s383-rhat/issm/svn/issm/trunk
source $ISSM_DIR/etc/environment.sh

#Go to the issm directory
cd $ISSM_DIR

#install ISSM

#1: install some packages
cd externalpackages
cd mpich2
	cp configs/wilkes/* .
	./install.sh
cd ../petsc
	cp configs/wilkes/* .
	./install.sh
cd ../metis
	cp config/linux/* .
	./install.sh
cd ../triangle
	cp config/lin64/* .
	./install.sh
cd $ISSM_DIR

#2: install automake and autoconf
cd devpackages
make
cd ..

#3: generate MakeFiles
sh scripts/automakererun.sh
sh config/wilkes/linux64.sh

#4: compile ISSM
make -j 8
make install

#5: change issm.rc
cd etc
cat cluster.rc | sed -e "s/cluster_codepath=\/u\/astrid1\/larour\/issm\/trunk\/bin/cluster_codepath=\/u\/wilkes-r1b\/morlighe\/svn\/issm\/trunk\/cron\/trunk\/bin/g" | sed -e "s/cluster_executionpath=\/u\/wilkes-r1b\/larour\/Testing\/Execution/cluster_executionpath=\/u\/wilkes-r1b\/morlighe\/ExecutionNightlyRun/g"> cluster.bak
mv cluster.bak cluster.rc
cd ..

#Launch matlab and the nightly run script
if [[ package == "" ]]
then
	matlab -nojvm -nosplash  > ./nightlylong.log << EOF 
startup
nightlyrun;
EOF
else
	matlab -nojvm -nosplash  > ./nightlylong.log << EOF 
startup
nightlyrun($1);
EOF
fi

#removed unused lines to deal with a smaller file
cat nightlylong.log | egrep 'difference: |NIGHTLYRUNTERMINATEDCORRECTLY' > nightly.log
#rm nightlylong.log

#Build html report
sh cron/report.sh
		
#send mail
source cron/mailinglist
for i in `echo $MAILINGLIST`; do
cat - report.html <<HERE | /usr/lib/sendmail  -oi -t
From: "ISSM Nightly run" <mathieu.morlighem@jpl.nasa.gov>
To: $i
Subject: Nightly runs of $ISSM_RELEASE on: $host_name. Date:$today.
Mime-Version: 1.0
Content-Type: text/html
HERE
done

#Erase log and error logs
#rm -rf nightly.log report.html

#Erase ice code
#cd ..
#rm -rf trunk/
