%
%  wrapper for normfit to avoid using the matlab statistics toolbox.
%
function [muhat,sigmahat,muci,sigmaci]=normfit_issm(x,alpha)

%  remove any NaN

	x=x(~isnan(x(:)));
	n=length(x);

%  explicitly calculate the moments

	muhat   =mean(x);
	sigmahat=std(x);

	if (nargout>2)
		if ~exist('alpha','var')
			alpha=0.05;
		end
		prob=1.-alpha/2.;

		try
			muci(1,1)   =muhat-tinv(prob,n-1)*sigmahat/sqrt(n);
			muci(2,1)   =muhat+tinv(prob,n-1)*sigmahat/sqrt(n);
			sigmaci(1,1)=sigmahat*sqrt((n-1)/chi2inv(prob   ,n-1));
			sigmaci(2,1)=sigmahat*sqrt((n-1)/chi2inv(1.-prob,n-1));
		catch me
			muci(1,1)   =muhat;
			muci(2,1)   =muhat;
			sigmaci(1,1)=sigmahat;
			sigmaci(2,1)=sigmahat;
		end
	end

end

