package com.example.issm;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

import android.app.Activity;
import android.os.Bundle;
import android.os.Environment;
import android.text.TextUtils;
import android.util.Log;
import android.view.Menu;
import android.view.View;
import android.widget.Button;
import android.widget.ImageButton;
import android.widget.Toast;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.res.AssetManager;
/////////////////////////////////////////////////////////////////////////// 
public class MapSelection extends Activity
{
	ISSM issm = new ISSM();
	private static final String PREFERENCE_FIRST_RUN = null;
	private String extStorageDirectory;
	private String issmFolder; 
//------------------------------------------------------------------------	
	public void onCreate(Bundle icicle)
	{
		super.onCreate(icicle);
		setContentView(R.layout.activity_mapselection);
		
		 SharedPreferences settings = this.getSharedPreferences("ISSM", 0);
		    boolean firstrun = settings.getBoolean(PREFERENCE_FIRST_RUN, true);
		    extStorageDirectory = Environment.getExternalStorageDirectory().toString();
		    
		    issmFolder = extStorageDirectory + "/ISSM/input_files/";
		    if (firstrun) 
		    { // Checks to see if we've ran the application b4
		        SharedPreferences.Editor e = settings.edit();
		        e.putBoolean(PREFERENCE_FIRST_RUN, false);
		        
		        e.commit();
		        // If not, run these methods:
		        SetDirectory(issmFolder);
		    }
		    
	
		//this button represents greenland and pass signal to issm
		ImageButton gl = (ImageButton) findViewById(R.id.button1);		
		gl.setOnClickListener(new View.OnClickListener() 
		{
			public void onClick(View v) 
			{
				Intent i = new Intent(MapSelection.this, ISSM.class);
				i.putExtra("map", "greenland");
				i.putExtra("pathToFile", issmFolder);
		        startActivity(i);
			}
		});
		
		//this button represents artarctica and pass signal to issm
		ImageButton art = (ImageButton) findViewById(R.id.button2);
		art.setOnClickListener(new View.OnClickListener() 
		{
			public void onClick(View v) 
			{
				Intent i = new Intent(MapSelection.this, ISSM.class);
				i.putExtra("map", "antarctica");
				i.putExtra("pathToFile", issmFolder);
		        startActivity(i);
			}
		});
	}
//------------------------------------------------------------------------
	private void SetDirectory(String directory) 
	{
	    if (android.os.Environment.getExternalStorageState().equals(android.os.Environment.MEDIA_MOUNTED)) 
	    {
	    	System.out.println(issmFolder);
	        File txtDirectory = new File(issmFolder);
	        
	        // Check and create directory in SDcard
	        if(!txtDirectory.exists())
	        {
	        	txtDirectory.mkdirs();
	        	System.out.println("making directory");
	        }
	        CopyAssets(); // Then run the method to copy the file.

	    } 
	    else if (android.os.Environment.getExternalStorageState().equals(android.os.Environment.MEDIA_MOUNTED_READ_ONLY)) 
	    {
	    	Toast toast = Toast.makeText(this.getApplicationContext(), "Memory is not mounted to device", Toast.LENGTH_LONG);
	    	toast.show();
	    }

	}
//----------------------------------------------------------------------------
	/**
	 * -- Copy the file from the assets folder to the sdCard
	 * ===========================================================
	 **/
		private void CopyAssets() 
		{
		    AssetManager assetManager = getAssets();
		    String[] files = null;
		    try {
		        files = assetManager.list("Map");
		    } catch (IOException e) {
		        Log.e("tag", e.getMessage());
		    }
		    for (int i = 0; i < files.length; i++) {
		        InputStream in = null;
		        OutputStream out = null;
		        try {
		            in = assetManager.open("Map/"+files[i]);
		            out = new FileOutputStream(issmFolder + files[i]);
		            copyFile(in, out);
		            in.close();
		            in = null;
		            out.flush();
		            out.close();
		            out = null;
		        } catch (Exception e) {
		            Log.e("tag", e.getMessage());
		        }
		    }
		    System.out.println("Done");
		}
//----------------------------------------------------------------------------
		private void copyFile(InputStream in, OutputStream out) throws IOException 
		{
		    byte[] buffer = new byte[1024];
		    int read;
		    while ((read = in.read(buffer)) != -1) {
		        out.write(buffer, 0, read);
		    }
		}
//----------------------------------------------------------------------------
}
/////////////////////////////////////////////////////////////////////////// 