package com.example.issm;

import java.nio.DoubleBuffer;

import android.content.Context;
import android.opengl.GLSurfaceView;
import android.view.MotionEvent;


class MyGLSurfaceView extends GLSurfaceView 
{
	private MyGLRenderer mRend;
	private int iter = 0;
	DoubleBuffer db;
	int size;
	double vmax = 0, vmin=0;
	final int rowNumber = 64;
	double[][] colorMap =  {
		{	1.0000,         0,         0 },
		{   1.0000,    0.0938    ,     0 },
		{    1.0000,    0.1875    ,     0},
		{   1.0000,    0.2812    ,     0},
		{   1.0000,    0.3750    ,     0},
		{   1.0000,    0.4688   ,      0},
		{   1.0000,    0.5625   ,      0},
		{   1.0000,    0.6562   ,      0},
		{   1.0000,    0.7500   ,      0},
		{   1.0000,    0.8438   ,      0},
		{   1.0000,    0.9375 ,        0},
		{   0.9688,    1.0000 ,        0},
		{   0.8750,    1.0000  ,       0},
		{   0.7812,    1.0000  ,       0},
		{   0.6875,    1.0000 ,        0},
		{   0.5938,    1.0000 ,        0},
		{   0.5000,    1.0000 ,        0},
		{   0.4062,    1.0000 ,        0},
		{   0.3125,   1.0000 ,        0},
		{   0.2188,   1.0000 ,        0},
		{   0.1250,  1.0000  ,       0},
		{   0.0312,    1.0000,         0},
		{        0,    1.0000,    0.0625},
		{        0,    1.0000,    0.1562},
		{        0,    1.0000,    0.2500},
		{       0,    1.0000,    0.3438},
		{        0,    1.0000,    0.4375},
		{        0,    1.0000,    0.5312},
		{        0,    1.0000,    0.6250},
		{        0,    1.0000,    0.7188},
		{        0,    1.0000,    0.8125},
		{        0,    1.0000,   0.9062},
		{        0,    1.0000,    1.0000},
		{        0,    0.9062,   1.0000},
		{        0,    0.8125,    1.0000},
		{        0,    0.7188,    1.0000},
		{        0,    0.6250,   1.0000},
		{        0,    0.5312,    1.0000},
		{        0,    0.4375,    1.0000},
		{        0,    0.3438,    1.0000},
		{        0,    0.2500,    1.0000},
		{        0,    0.1562,    1.0000},
		{        0,    0.0625,    1.0000},
		{   0.0312,         0,    1.0000},
		{   0.1250,         0,    1.0000},
		{   0.2188,         0,    1.0000},
		{   0.3125,         0,    1.0000},
		{   0.4062,         0,    1.0000},
		{   0.5000,         0,    1.0000},
		{   0.5938,         0,    1.0000},
		{   0.6875,         0,    1.0000},
		{   0.7812,         0,    1.0000},
		{   0.8750,         0,    1.0000},
		{   0.9688,         0,    1.0000},
		{   1.0000,         0,    0.9375},
		{   1.0000,         0,    0.8438},
		{   1.0000,         0,    0.7500},
		{   1.0000,         0,    0.6562},
		{   1.0000,         0,    0.5625},
		{   1.0000,         0,    0.4688},
		{   1.0000,         0,    0.3750},
		{   1.0000,         0,   0.2812},
		{   1.0000,         0,    0.1875},
		{   1.0000,         0,    0.0938}};
	float[][] colorMapInFloat;
    public MyGLSurfaceView(Context context, DoubleBuffer db, int size) 
    {
        super(context);

        // Create an OpenGL ES 2.0 context.
        setEGLContextClientVersion(2);
        this.db = db;
        this.size = size;
        colorMapInFloat = new float[64][3];
        
        for (int i = 0 ; i < 64; i++)
        {
        	for (int j = 0 ; j < 3; j++)
        	{
        		colorMapInFloat[i][j] = (float) colorMap[i][j];
        	}
        }
        vmin = db.get(9);
        findMinMaxVelocity();
        System.out.println("max" +vmax +"  "+ "min"+vmin ); 
        intialize();
    }
    private void intialize()
    {
    	final int NMAX_TRIANGLES = 2000;
        final int MAX_VERTICES = 21;
        float f[][] = new float[size][MAX_VERTICES];
        int n, random;
        final int SCALE_FACTOR = 700000;
		for (int i = 0; i < size; i++)
		{
				f[i][0] = (float)db.get(12*i+0)/SCALE_FACTOR;
				f[i][1] = (float)db.get(12*i+1)/SCALE_FACTOR;
				f[i][2] = (float)db.get(12*i+2)/SCALE_FACTOR;
				f[i][7] = (float)db.get(12*i+3)/SCALE_FACTOR;
				f[i][8] = (float)db.get(12*i+4)/SCALE_FACTOR;
				f[i][9] = (float)db.get(12*i+5)/SCALE_FACTOR;
				f[i][14] = (float)db.get(12*i+6)/SCALE_FACTOR;
				f[i][15] = (float)db.get(12*i+7)/SCALE_FACTOR;
				f[i][16] = (float)db.get(12*i+8)/SCALE_FACTOR;
				
				f[i][6] = 1.0f;
				f[i][13] = 1.0f;
				f[i][20] = 1.0f;
				
				int index1 = getRowColor(db.get(12*i+9));
				int index2 = getRowColor(db.get(12*i+10));
				int index3 = getRowColor(db.get(12*i+11));
				
				float r1 = colorMapInFloat[index1][0];
				float g1 = colorMapInFloat[index1][1];
				float b1 = colorMapInFloat[index1][2];
				
				float r2 = colorMapInFloat[index2][0];
				float g2 = colorMapInFloat[index2][1];
				float b2 = colorMapInFloat[index2][2];
				
				float r3 = colorMapInFloat[index3][0];
				float g3 = colorMapInFloat[index3][1];
				float b3 = colorMapInFloat[index3][2];
				
				
				f[i][3] = r1;
				f[i][4] = g1;
				f[i][5] = b1;
				
				f[i][10] = r2;
				f[i][11] = g2;
				f[i][12] = b2;
				
				f[i][17] = r3;
				f[i][18] = g3;
				f[i][19] = b3;

		}
    	mRend = new MyGLRenderer(f);
    	// Set the Renderer for drawing on the GLSurfaceView
        setRenderer(mRend);

        // Render the view only when there is a change in the drawing data
        setRenderMode(GLSurfaceView.RENDERMODE_WHEN_DIRTY);
    }
    private void findMinMaxVelocity()
    {
    	for(int i = 0; i < size*12; i++)
    	{
    		if(i%12==9 || i%12==10 ||i%12==11 )
    		{
    			if (db.get(i) <  vmin) vmin = db.get(i);
    			if (db.get(i) >= vmax) vmax = db.get(i);
    		}
    		else continue; 
    	}
    	
    }
    private float getData()
    {
    	float result = (float) db.get(iter)/1000000;
    	//System.out.println("result" + result);
    	if(iter < size*12) iter++;
    	else iter = 0;
    	return result;
    }
    
    private int getRowColor(double velocity)
    {
    	//velocity = 0;
    	double alpha=(vmax-velocity)/(vmax-vmin) ;
    	int row = (int) (alpha * (rowNumber-1));
    	return row;
    }
    
    private final float TOUCH_SCALE_FACTOR = 180.0f / 320;
    private float mPreviousX;
    
    private float mPreviousY;
    @Override
    public boolean onTouchEvent(MotionEvent e) {
        // MotionEvent reports input details from the touch screen
        // and other input controls. In this case, you are only
        // interested in events where the touch position changed.

        float x = e.getX();
        float y = e.getY();

        switch (e.getAction()) {
            case MotionEvent.ACTION_MOVE:

                float dx = x - mPreviousX;
                float dy = y - mPreviousY;

                // reverse direction of rotation above the mid-line
                if (y > getHeight() / 2) {
                  dx = dx * -1 ;
                }

                // reverse direction of rotation to left of the mid-line
                if (x < getWidth() / 2) {
                  dy = dy * -1 ;
                }

                mRend.mAngle += (dx + dy) * TOUCH_SCALE_FACTOR;  // = 180.0f / 320
                requestRender();
        }

        mPreviousX = x;
        mPreviousY = y;
        return true;
    }
}