package com.example.issm;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;

import android.os.Bundle;
import android.app.Activity;
import android.content.res.AssetManager;
import android.text.TextUtils;
import android.view.Menu;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.Button;
import android.widget.EditText;
import android.widget.TextView;


public class ISSM extends Activity implements OnClickListener 
{
	private EditText input;
	private TextView output;
	private DoubleBuffer buff;
	private IssmJni issmNative;
	private String mapName;
	private String issmFolder;
	private int size;
    @Override
  //------------------------------------------------------------------------------------------------    
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Bundle map = getIntent().getExtras();
        {
        	if(map!= null)
        	{
        		mapName = map.getString("map");
        		issmFolder = map.getString("pathToFile");
        	}
        }
        setContentView(R.layout.activity_issm);
        this.input  = (EditText) super.findViewById(R.id.input);
        this.output  = (TextView) super.findViewById(R.id.output);
        Button button = (Button) super.findViewById(R.id.button1);
        button.setOnClickListener(this);
        
        //load up the ISSM library and create double buffer in java
        //which later on will be pass for native allocation.
        issmNative = new IssmJni();
        this.createModel();
        buff = ByteBuffer.allocateDirect(size*12*8).order(ByteOrder.nativeOrder()).asDoubleBuffer();
    }
//------------------------------------------------------------------------------------------------    
    public void createModel()
    {
		String solution_type="DiagnosticSolution";
    	String file = "";
    	if( mapName.equals("greenland"))
		{
    		file = "greenland";
		}
    	else file = "antarctica";

    	size = issmNative.createISSMModel(solution_type,issmFolder,file);
    }
//------------------------------------------------------------------------------------------------
    public void fillBuffer()
    {
    	issmNative.solveISSMModel(5,buff);

		//for(int i=0;i< size*12;i++)
			//System.out.println(buff.get(i));

    }
 //------------------------------------------------------------------------------------------------   
    public void onClick(View view) 
	{
		//factorial method
		String input = this.input.getText().toString();
		if(TextUtils.isEmpty(input))
		{
			return;
		}		
		long resultfromFac = issmNative.fac(Long.parseLong(input));
		//example of how to fill buffer Native
		this.fillBuffer();
		
		//print result from fac and the first two slot of filled buffer.
		this.output.setText("Result = " + resultfromFac + "\n" 
										+ "First slot from buffer:\n" 
										+ buff.get(0) + " size " +  size);

	}
}
