package com.example.issm_visual;


import android.app.Activity;
import android.content.DialogInterface.OnClickListener;
import android.opengl.GLSurfaceView;
import android.os.Bundle;
import android.view.Menu;
import android.view.View;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.SeekBar;
import android.widget.SeekBar.OnSeekBarChangeListener;
import android.widget.TextView;

public class ISSMVisual extends Activity implements OnSeekBarChangeListener
{
	private SeekBar bar;
    private TextView /*txtStatus,*/ txtValue;
    private GLSurfaceView mGLView;
	private FrameLayout frame;
	
    @Override
    public void onCreate(Bundle savedInstanceState) 
    {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_issmvisual);
        
        bar = (SeekBar)findViewById(R.id.seekBar); // make seekbar object
        bar.setOnSeekBarChangeListener(this); // set seekbar listener
        txtValue = (TextView)findViewById(R.id.value);
        Button reset = (Button)findViewById(R.id.button1);
        reset.setOnClickListener(new View.OnClickListener()
        {
            public void onClick(View v) 
            {
            	frame.removeView(mGLView);
            	mGLView = new MyGLSurfaceView(ISSMVisual.this);
            	frame.addView(mGLView);
            }
        });
        //txtStatus = (TextView)findViewById(R.id.status);
        
        mGLView = new MyGLSurfaceView(this);
        frame = (FrameLayout)findViewById(R.id.frame);
        frame.addView(mGLView);
    }
	public void onProgressChanged(SeekBar seekBar, int val,
    		boolean fromUser) 
    {
    	// change progress text label with current Seekbar value
    	txtValue.setText("alpha value = " + val);
    	//txtStatus.setText("Status: changing");
    }
	
    public void onStartTrackingTouch(SeekBar seekBar) {/*txtStatus.setText("Status: Starting to track touch");*/}
    
    public void onStopTrackingTouch(SeekBar seekBar) 
    {
    	seekBar.setSecondaryProgress(seekBar.getProgress()); // set the shade of the previous value.
    	
    	//txtStatus.setText("Status: Ended tracking touch");
    	frame.removeView(mGLView);
    	mGLView = new MyGLSurfaceView(this);
        frame.addView(mGLView);
    }
    
    @Override
    protected void onPause() 
    {
        super.onPause();
        // The following call pauses the rendering thread.
        // If your OpenGL application is memory intensive,
        // you should consider de-allocating objects that
        // consume significant memory here.
        mGLView.onPause();
    }
    
    @Override
    protected void onResume() 
    {
        super.onResume();
        // The following call resumes a paused rendering thread.
        // If you de-allocated graphic objects for onPause()
        // this is a good place to re-allocate them.
        mGLView.onResume();
    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu) 
    {
        getMenuInflater().inflate(R.menu.activity_issmvisual, menu);
        return true;
    }
}
