>> md.flowequation

ans = 

   flow equation parameters:
	         ismacayealpattyn       : 0    -- is the macayeal or pattyn approximation used ?
				ishutter               : 0    -- is the shallow ice approximation used ?
				isstokes               : 0    -- are the Full-Stokes equations used ?
				vertex_equation        : N/A  -- flow equation for each vertex
				element_equation       : N/A  -- flow equation for each element
				bordermacayeal         : N/A  -- vertices on MacAyeal's border (for tiling)
				borderpattyn           : N/A  -- vertices on Pattyn's border (for tiling)
				borderstokes           : N/A  -- vertices on Stokes' border (for tiling)

md=setflowequation(md,'hutter','all')
md=setflowequation(md,'stokes','all')
md=setflowequation(md,'macayeal','all')
md=setflowequation(md,'pattyn','all')

>> plotmodel(md,'data','elements_type')

>> md.diagnostic

ans = 

   Diagnostic solution parameters:

     Convergence criteria:
	     restol                 : 0.0001          -- mechanical equilibrium residue convergence criterion
		  reltol                 : 0.01            -- velocity relative convergence criterion, NaN -> not applied
		  abstol                 : 10              -- velocity absolute convergence criterion, NaN -> not applied
	     maxiter                : 100             -- maximum number of nonlinear iterations
		  viscosity_overshoot    : 0               -- over-shooting constant new=new+C*(new-old)

     boundary conditions:
		  spcvx                  : N/A             -- x-axis velocity constraint (NaN means no constraint)
		  spcvy                  : N/A             -- y-axis velocity constraint (NaN means no constraint)
		  spcvz                  : N/A             -- z-axis velocity constraint (NaN means no constraint)
		  icefront               : N/A             -- segments on ice front list (last column 0-> Air, 1-> Water, 2->Ice

     Rift options:
		  rift_penalty_threshold : 0               -- threshold for instability of mechanical constraints
		  rift_penalty_lock      : 10              -- number of iterations before rift penalties are locked

     Penalty options:
		  penalty_factor         : 3               -- offset used by penalties: penalty = Kmax*10^offset
		  vertex_pairing         : N/A             -- pairs of vertices that are penalized

     Other:
		  shelf_dampening        : 0               -- use dampening for floating ice ?  Only for Stokes model
		  stokesreconditioning   : 10000000000000  -- multiplier for incompressibility equation.  Only for Stokes model
		  referential            : N/A             -- local referential
		  requested_outputs      : N/A             -- additional outputs requested

>> md=SetIceSheetBC(md)
>> md=SetIceShelfBC(md,'Front.exp')
>> md=SetMarineIceSheefBC(md,'Front.exp')

>> plotmodel(md,'data','BC')

md=setflowequation(md,'pattyn',md.elementongroundedice,'fill','macayeal','coupling','penalties')
md=setflowequation(md,'pattyn',md.elementongroundedice,'fill','macayeal','coupling','tiling')
md=setflowequation(md,'stokes','Contour.exp','fill','pattyn')

>> exptool('Contour.exp')

>> plotmodel(md,'data','elements_type','edgecolor','k','expdisp','Contour.exp')

md=setflowequation(md,'macayeal','FloatingIce.exp','fill','pattyn','coupling','penalties')
