#include <jni.h>
#include "../../../c/android/fac.h"
#include "../../../c/issm.h"
#include <cstddef>
#include <stdio.h>
///////////////////////////////////////////////////////////////////////////////////////////
namespace com_example_issm
{
	fac* f;
	//FemModel *fm;
//------------------------------------------------------------------------------------
	jint initilize(JNIEnv *env, jclass clazz, jstring file)
	{
		const char *nativefile = env->GetStringUTFChars(file,0);

		f = new fac();

		//call Model constructor passing in infile as File Descriptor parameter.
		// fm  = new FemModel(nativefile);

		env->ReleaseStringUTFChars(file, nativefile); //must realease the char*
		//jint size = (jint) fm->bufferSize();
		//return size;

		return 0; //return 0 for now.
	}
//------------------------------------------------------------------------------------
	//fill out the first two slots, extract the same way in java using get(int position)
	void solve(JNIEnv *env, jclass clazz , jint alpha, jobject buf)
	{
		jdouble *dBuf = (jdouble *)env->GetDirectBufferAddress(buf);

		//pass bBuff to fem model to allocate data
		// fm -> solve(dBuf, alpha);

	}
//------------------------------------------------------------------------------------
	jlong factorial(JNIEnv *env, jclass clazz, jlong n)
	{
		if( f != NULL)
			return (jlong) (f->factorial(n));
		return 0;
	}

//------------------------------------------------------------------------------------
	static JNINativeMethod method_table[] =
	{
			{"fac"      	,     "(J)J" 	, (void *) factorial},
			{"createISSMModel"   ,"(Ljava/lang/String;)I"  , (void *) initilize},
			{"processBuffer", "(ILjava/nio/DoubleBuffer;)V", (void *) solve}
	};
}
//------------------------------------------------------------------------------------
using namespace com_example_issm;

extern "C" jint JNI_OnLoad(JavaVM* vm, void* reserved)
{
    JNIEnv* env;
    if (vm->GetEnv(reinterpret_cast<void**>(&env), JNI_VERSION_1_6) != JNI_OK) {
        return -1;
    }
    else
    {
    	jclass clazz = env->FindClass("com/example/issm/IssmJni");
    	if(clazz)
    	{
    		env->RegisterNatives(clazz, method_table, 3);
    		env->DeleteLocalRef(clazz);
    		return JNI_VERSION_1_6;
    	}
    	else return -1;
    }
}
///////////////////////////////////////////////////////////////////////////////////////////
