import numpy
from model import *
from triangle import *
from setmask import *
from parameterize import *
from setflowequation import *
from EnumDefinitions import *
from solve import *
from MatlabFuncs import *

md=triangle(model(),'../Exp/Square.exp',180000.)
md=setmask(md,'all','')
md=parameterize(md,'../Par/SquareShelf.py')
md.extrude(3,1.)
md=setflowequation(md,'macayeal','all')
md.cluster=generic('name',oshostname(),'np',3)
md.thermal.spctemperature=numpy.vstack((numpy.hstack((md.thermal.spctemperature, md.thermal.spctemperature+5., md.thermal.spctemperature+10., md.thermal.spctemperature+15.)), [1.5,2.5,3.5,4.]))
md.timestepping.time_step=1.
md.timestepping.final_time=4.
md.transient.isdiagnostic=False
md.transient.isprognostic=False
md.transient.isthermal=True
md.transient.isgroundingline=False
md=solve(md,TransientSolutionEnum())

#Fields and tolerances to track changes
field_names     =['Temperature1','BasalforcingsMeltingRate1','Temperature2','BasalforcingsMeltingRate2','Temperature3','BasalforcingsMeltingRate3','Temperature4','BasalforcingsMeltingRate4']
field_tolerances=[1e-13,1e-6,1e-13,1e-6,1e-13,1e-6,1e-13,1e-6]
field_values=[\
	md.results.TransientSolution[0].Temperature,\
	md.results.TransientSolution[0].BasalforcingsMeltingRate,\
	md.results.TransientSolution[1].Temperature,\
	md.results.TransientSolution[1].BasalforcingsMeltingRate,\
	md.results.TransientSolution[2].Temperature,\
	md.results.TransientSolution[2].BasalforcingsMeltingRate,\
	md.results.TransientSolution[3].Temperature,\
	md.results.TransientSolution[3].BasalforcingsMeltingRate,\
	]
