/*\file ElementConnectivity.c
 *\brief: build element connectivity using node connectivity and elements. 
 */

#include "./ElementConnectivity.h"

void ElementConnectivityUsage(void) {/*{{{*/
	_pprintLine_("");
	_pprintLine_("   usage: elementconnectivity = " << __FUNCT__ << "(elements, nodeconnectivity);");
	_pprintLine_("");
}/*}}}*/
WRAPPER(ElementConnectivity){

	/*inputs: */
	double* elements=NULL;
	double* nodeconnectivity=NULL;
	int     nel,nods;
	int     width;

	/*outputs: */
	double* elementconnectivity=NULL;

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments: */
	CHECKARGUMENTS(NLHS,NRHS,&ElementConnectivityUsage);
        
	/*Input datasets: */
	FetchData(&elements,&nel,NULL,ELEMENTS);
	FetchData(&nodeconnectivity,&nods,&width,NODECONNECTIVITY);

	/*!Generate internal degree of freedom numbers: */
	ElementConnectivityx(&elementconnectivity, elements,nel, nodeconnectivity, nods, width);

	/*write output datasets: */
	WriteData(ELEMENTCONNECTIVITY,elementconnectivity,nel,3);

	/*end module: */
	MODULEEND();
}
